/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result of a successful invocation of the <code>DescribeSourceRegions</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSourceRegionsResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeSourceRegionsResponse.Builder, DescribeSourceRegionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSourceRegionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<SourceRegion>> SOURCE_REGIONS_FIELD = SdkField
            .<List<SourceRegion>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSourceRegionsResponse::sourceRegions))
            .setter(setter(Builder::sourceRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SourceRegion")
                            .memberFieldInfo(
                                    SdkField.<SourceRegion> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceRegion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SourceRegion").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            SOURCE_REGIONS_FIELD));

    private final String marker;

    private final List<SourceRegion> sourceRegions;

    private DescribeSourceRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.sourceRegions = builder.sourceRegions;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the SourceRegions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSourceRegions() {
        return sourceRegions != null && !(sourceRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of SourceRegion instances that contains each source AWS Region that the current AWS Region can get a read
     * replica or a DB snapshot from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSourceRegions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of SourceRegion instances that contains each source AWS Region that the current AWS Region can get
     *         a read replica or a DB snapshot from.
     */
    public List<SourceRegion> sourceRegions() {
        return sourceRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSourceRegionsResponse)) {
            return false;
        }
        DescribeSourceRegionsResponse other = (DescribeSourceRegionsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(sourceRegions(), other.sourceRegions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSourceRegionsResponse").add("Marker", marker()).add("SourceRegions", sourceRegions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "SourceRegions":
            return Optional.ofNullable(clazz.cast(sourceRegions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSourceRegionsResponse, T> g) {
        return obj -> g.apply((DescribeSourceRegionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSourceRegionsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of SourceRegion instances that contains each source AWS Region that the current AWS Region can get a
         * read replica or a DB snapshot from.
         * </p>
         * 
         * @param sourceRegions
         *        A list of SourceRegion instances that contains each source AWS Region that the current AWS Region can
         *        get a read replica or a DB snapshot from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegions(Collection<SourceRegion> sourceRegions);

        /**
         * <p>
         * A list of SourceRegion instances that contains each source AWS Region that the current AWS Region can get a
         * read replica or a DB snapshot from.
         * </p>
         * 
         * @param sourceRegions
         *        A list of SourceRegion instances that contains each source AWS Region that the current AWS Region can
         *        get a read replica or a DB snapshot from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegions(SourceRegion... sourceRegions);

        /**
         * <p>
         * A list of SourceRegion instances that contains each source AWS Region that the current AWS Region can get a
         * read replica or a DB snapshot from.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SourceRegion>.Builder} avoiding the need to
         * create one manually via {@link List<SourceRegion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SourceRegion>.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceRegions(List<SourceRegion>)}.
         * 
         * @param sourceRegions
         *        a consumer that will call methods on {@link List<SourceRegion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceRegions(List<SourceRegion>)
         */
        Builder sourceRegions(Consumer<SourceRegion.Builder>... sourceRegions);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<SourceRegion> sourceRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSourceRegionsResponse model) {
            super(model);
            marker(model.marker);
            sourceRegions(model.sourceRegions);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<SourceRegion.Builder> getSourceRegions() {
            return sourceRegions != null ? sourceRegions.stream().map(SourceRegion::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder sourceRegions(Collection<SourceRegion> sourceRegions) {
            this.sourceRegions = SourceRegionListCopier.copy(sourceRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRegions(SourceRegion... sourceRegions) {
            sourceRegions(Arrays.asList(sourceRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRegions(Consumer<SourceRegion.Builder>... sourceRegions) {
            sourceRegions(Stream.of(sourceRegions).map(c -> SourceRegion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSourceRegions(Collection<SourceRegion.BuilderImpl> sourceRegions) {
            this.sourceRegions = SourceRegionListCopier.copyFromBuilder(sourceRegions);
        }

        @Override
        public DescribeSourceRegionsResponse build() {
            return new DescribeSourceRegionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
