/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result of a successful invocation of the <code>DescribeReservedDBInstances</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedDbInstancesResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeReservedDbInstancesResponse.Builder, DescribeReservedDbInstancesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservedDbInstancesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ReservedDBInstance>> RESERVED_DB_INSTANCES_FIELD = SdkField
            .<List<ReservedDBInstance>> builder(MarshallingType.LIST)
            .getter(getter(DescribeReservedDbInstancesResponse::reservedDBInstances))
            .setter(setter(Builder::reservedDBInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReservedDBInstance")
                            .memberFieldInfo(
                                    SdkField.<ReservedDBInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedDBInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReservedDBInstance").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            RESERVED_DB_INSTANCES_FIELD));

    private final String marker;

    private final List<ReservedDBInstance> reservedDBInstances;

    private DescribeReservedDbInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedDBInstances = builder.reservedDBInstances;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the ReservedDBInstances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReservedDBInstances() {
        return reservedDBInstances != null && !(reservedDBInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of reserved DB instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReservedDBInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of reserved DB instances.
     */
    public List<ReservedDBInstance> reservedDBInstances() {
        return reservedDBInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(reservedDBInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedDbInstancesResponse)) {
            return false;
        }
        DescribeReservedDbInstancesResponse other = (DescribeReservedDbInstancesResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(reservedDBInstances(), other.reservedDBInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeReservedDbInstancesResponse").add("Marker", marker())
                .add("ReservedDBInstances", reservedDBInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReservedDBInstances":
            return Optional.ofNullable(clazz.cast(reservedDBInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedDbInstancesResponse, T> g) {
        return obj -> g.apply((DescribeReservedDbInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReservedDbInstancesResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of reserved DB instances.
         * </p>
         * 
         * @param reservedDBInstances
         *        A list of reserved DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstances(Collection<ReservedDBInstance> reservedDBInstances);

        /**
         * <p>
         * A list of reserved DB instances.
         * </p>
         * 
         * @param reservedDBInstances
         *        A list of reserved DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstances(ReservedDBInstance... reservedDBInstances);

        /**
         * <p>
         * A list of reserved DB instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedDBInstance>.Builder} avoiding the
         * need to create one manually via {@link List<ReservedDBInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedDBInstance>.Builder#build()} is called immediately
         * and its result is passed to {@link #reservedDBInstances(List<ReservedDBInstance>)}.
         * 
         * @param reservedDBInstances
         *        a consumer that will call methods on {@link List<ReservedDBInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedDBInstances(List<ReservedDBInstance>)
         */
        Builder reservedDBInstances(Consumer<ReservedDBInstance.Builder>... reservedDBInstances);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ReservedDBInstance> reservedDBInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedDbInstancesResponse model) {
            super(model);
            marker(model.marker);
            reservedDBInstances(model.reservedDBInstances);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedDBInstance.Builder> getReservedDBInstances() {
            return reservedDBInstances != null ? reservedDBInstances.stream().map(ReservedDBInstance::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedDBInstances(Collection<ReservedDBInstance> reservedDBInstances) {
            this.reservedDBInstances = ReservedDBInstanceListCopier.copy(reservedDBInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedDBInstances(ReservedDBInstance... reservedDBInstances) {
            reservedDBInstances(Arrays.asList(reservedDBInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedDBInstances(Consumer<ReservedDBInstance.Builder>... reservedDBInstances) {
            reservedDBInstances(Stream.of(reservedDBInstances).map(c -> ReservedDBInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReservedDBInstances(Collection<ReservedDBInstance.BuilderImpl> reservedDBInstances) {
            this.reservedDBInstances = ReservedDBInstanceListCopier.copyFromBuilder(reservedDBInstances);
        }

        @Override
        public DescribeReservedDbInstancesResponse build() {
            return new DescribeReservedDbInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
