/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstallationMediaRequest extends RdsRequest implements
        ToCopyableBuilder<DescribeInstallationMediaRequest.Builder, DescribeInstallationMediaRequest> {
    private static final SdkField<String> INSTALLATION_MEDIA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInstallationMediaRequest::installationMediaId)).setter(setter(Builder::installationMediaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallationMediaId").build())
            .build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeInstallationMediaRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeInstallationMediaRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInstallationMediaRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTALLATION_MEDIA_ID_FIELD,
            FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String installationMediaId;

    private final List<Filter> filters;

    private final Integer maxRecords;

    private final String marker;

    private DescribeInstallationMediaRequest(BuilderImpl builder) {
        super(builder);
        this.installationMediaId = builder.installationMediaId;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The installation medium ID.
     * </p>
     * 
     * @return The installation medium ID.
     */
    public String installationMediaId() {
        return installationMediaId;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A filter that specifies one or more installation media to describe. Supported filters include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>custom-availability-zone-id</code> - Accepts custom Availability Zone (AZ) identifiers. The results list
     * includes information about only the custom AZs identified by these identifiers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>engine</code> - Accepts database engines. The results list includes information about only the database
     * engines identified by these identifiers.
     * </p>
     * <p>
     * For more information about the valid engines for installation media, see <a>ImportInstallationMedia</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A filter that specifies one or more installation media to describe. Supported filters include the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>custom-availability-zone-id</code> - Accepts custom Availability Zone (AZ) identifiers. The results
     *         list includes information about only the custom AZs identified by these identifiers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>engine</code> - Accepts database engines. The results list includes information about only the
     *         database engines identified by these identifiers.
     *         </p>
     *         <p>
     *         For more information about the valid engines for installation media, see <a>ImportInstallationMedia</a>.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous DescribeInstallationMedia request. If this parameter is
     * specified, the response includes only records beyond the marker, up to the value specified by
     * <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous DescribeInstallationMedia request. If this parameter
     *         is specified, the response includes only records beyond the marker, up to the value specified by
     *         <code>MaxRecords</code>.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(installationMediaId());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstallationMediaRequest)) {
            return false;
        }
        DescribeInstallationMediaRequest other = (DescribeInstallationMediaRequest) obj;
        return Objects.equals(installationMediaId(), other.installationMediaId()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeInstallationMediaRequest").add("InstallationMediaId", installationMediaId())
                .add("Filters", filters()).add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstallationMediaId":
            return Optional.ofNullable(clazz.cast(installationMediaId()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstallationMediaRequest, T> g) {
        return obj -> g.apply((DescribeInstallationMediaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstallationMediaRequest> {
        /**
         * <p>
         * The installation medium ID.
         * </p>
         * 
         * @param installationMediaId
         *        The installation medium ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installationMediaId(String installationMediaId);

        /**
         * <p>
         * A filter that specifies one or more installation media to describe. Supported filters include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>custom-availability-zone-id</code> - Accepts custom Availability Zone (AZ) identifiers. The results
         * list includes information about only the custom AZs identified by these identifiers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>engine</code> - Accepts database engines. The results list includes information about only the database
         * engines identified by these identifiers.
         * </p>
         * <p>
         * For more information about the valid engines for installation media, see <a>ImportInstallationMedia</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        A filter that specifies one or more installation media to describe. Supported filters include the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>custom-availability-zone-id</code> - Accepts custom Availability Zone (AZ) identifiers. The
         *        results list includes information about only the custom AZs identified by these identifiers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>engine</code> - Accepts database engines. The results list includes information about only the
         *        database engines identified by these identifiers.
         *        </p>
         *        <p>
         *        For more information about the valid engines for installation media, see
         *        <a>ImportInstallationMedia</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * A filter that specifies one or more installation media to describe. Supported filters include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>custom-availability-zone-id</code> - Accepts custom Availability Zone (AZ) identifiers. The results
         * list includes information about only the custom AZs identified by these identifiers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>engine</code> - Accepts database engines. The results list includes information about only the database
         * engines identified by these identifiers.
         * </p>
         * <p>
         * For more information about the valid engines for installation media, see <a>ImportInstallationMedia</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        A filter that specifies one or more installation media to describe. Supported filters include the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>custom-availability-zone-id</code> - Accepts custom Availability Zone (AZ) identifiers. The
         *        results list includes information about only the custom AZs identified by these identifiers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>engine</code> - Accepts database engines. The results list includes information about only the
         *        database engines identified by these identifiers.
         *        </p>
         *        <p>
         *        For more information about the valid engines for installation media, see
         *        <a>ImportInstallationMedia</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * A filter that specifies one or more installation media to describe. Supported filters include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>custom-availability-zone-id</code> - Accepts custom Availability Zone (AZ) identifiers. The results
         * list includes information about only the custom AZs identified by these identifiers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>engine</code> - Accepts database engines. The results list includes information about only the database
         * engines identified by these identifiers.
         * </p>
         * <p>
         * For more information about the valid engines for installation media, see <a>ImportInstallationMedia</a>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * An optional pagination token provided by a previous DescribeInstallationMedia request. If this parameter is
         * specified, the response includes only records beyond the marker, up to the value specified by
         * <code>MaxRecords</code>.
         * </p>
         * 
         * @param maxRecords
         *        An optional pagination token provided by a previous DescribeInstallationMedia request. If this
         *        parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String installationMediaId;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstallationMediaRequest model) {
            super(model);
            installationMediaId(model.installationMediaId);
            filters(model.filters);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getInstallationMediaId() {
            return installationMediaId;
        }

        @Override
        public final Builder installationMediaId(String installationMediaId) {
            this.installationMediaId = installationMediaId;
            return this;
        }

        public final void setInstallationMediaId(String installationMediaId) {
            this.installationMediaId = installationMediaId;
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstallationMediaRequest build() {
            return new DescribeInstallationMediaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
