/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExportTasksResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeExportTasksResponse.Builder, DescribeExportTasksResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeExportTasksResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ExportTask>> EXPORT_TASKS_FIELD = SdkField
            .<List<ExportTask>> builder(MarshallingType.LIST)
            .getter(getter(DescribeExportTasksResponse::exportTasks))
            .setter(setter(Builder::exportTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ExportTask")
                            .memberFieldInfo(
                                    SdkField.<ExportTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ExportTask").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            EXPORT_TASKS_FIELD));

    private final String marker;

    private final List<ExportTask> exportTasks;

    private DescribeExportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.exportTasks = builder.exportTasks;
    }

    /**
     * <p>
     * A pagination token that can be used in a later <code>DescribeExportTasks</code> request. A marker is used for
     * pagination to identify the location to begin output for the next response of <code>DescribeExportTasks</code>.
     * </p>
     * 
     * @return A pagination token that can be used in a later <code>DescribeExportTasks</code> request. A marker is used
     *         for pagination to identify the location to begin output for the next response of
     *         <code>DescribeExportTasks</code>.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the ExportTasks property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasExportTasks() {
        return exportTasks != null && !(exportTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about an export of a snapshot to Amazon S3.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExportTasks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about an export of a snapshot to Amazon S3.
     */
    public List<ExportTask> exportTasks() {
        return exportTasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(exportTasks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksResponse)) {
            return false;
        }
        DescribeExportTasksResponse other = (DescribeExportTasksResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(exportTasks(), other.exportTasks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeExportTasksResponse").add("Marker", marker()).add("ExportTasks", exportTasks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ExportTasks":
            return Optional.ofNullable(clazz.cast(exportTasks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportTasksResponse, T> g) {
        return obj -> g.apply((DescribeExportTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExportTasksResponse> {
        /**
         * <p>
         * A pagination token that can be used in a later <code>DescribeExportTasks</code> request. A marker is used for
         * pagination to identify the location to begin output for the next response of <code>DescribeExportTasks</code>
         * .
         * </p>
         * 
         * @param marker
         *        A pagination token that can be used in a later <code>DescribeExportTasks</code> request. A marker is
         *        used for pagination to identify the location to begin output for the next response of
         *        <code>DescribeExportTasks</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Information about an export of a snapshot to Amazon S3.
         * </p>
         * 
         * @param exportTasks
         *        Information about an export of a snapshot to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTasks(Collection<ExportTask> exportTasks);

        /**
         * <p>
         * Information about an export of a snapshot to Amazon S3.
         * </p>
         * 
         * @param exportTasks
         *        Information about an export of a snapshot to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTasks(ExportTask... exportTasks);

        /**
         * <p>
         * Information about an export of a snapshot to Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExportTask>.Builder} avoiding the need to
         * create one manually via {@link List<ExportTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExportTask>.Builder#build()} is called immediately and its
         * result is passed to {@link #exportTasks(List<ExportTask>)}.
         * 
         * @param exportTasks
         *        a consumer that will call methods on {@link List<ExportTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportTasks(List<ExportTask>)
         */
        Builder exportTasks(Consumer<ExportTask.Builder>... exportTasks);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ExportTask> exportTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksResponse model) {
            super(model);
            marker(model.marker);
            exportTasks(model.exportTasks);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ExportTask.Builder> getExportTasks() {
            return exportTasks != null ? exportTasks.stream().map(ExportTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder exportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTasksListCopier.copy(exportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(ExportTask... exportTasks) {
            exportTasks(Arrays.asList(exportTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(Consumer<ExportTask.Builder>... exportTasks) {
            exportTasks(Stream.of(exportTasks).map(c -> ExportTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setExportTasks(Collection<ExportTask.BuilderImpl> exportTasks) {
            this.exportTasks = ExportTasksListCopier.copyFromBuilder(exportTasks);
        }

        @Override
        public DescribeExportTasksResponse build() {
            return new DescribeExportTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
