/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDbInstanceRequest extends RdsRequest implements
        ToCopyableBuilder<DeleteDbInstanceRequest.Builder, DeleteDbInstanceRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteDbInstanceRequest::dbInstanceIdentifier)).setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<Boolean> SKIP_FINAL_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteDbInstanceRequest::skipFinalSnapshot)).setter(setter(Builder::skipFinalSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalSnapshot").build()).build();

    private static final SdkField<String> FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteDbInstanceRequest::finalDBSnapshotIdentifier))
            .setter(setter(Builder::finalDBSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalDBSnapshotIdentifier").build())
            .build();

    private static final SdkField<Boolean> DELETE_AUTOMATED_BACKUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteDbInstanceRequest::deleteAutomatedBackups)).setter(setter(Builder::deleteAutomatedBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAutomatedBackups").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            SKIP_FINAL_SNAPSHOT_FIELD, FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD, DELETE_AUTOMATED_BACKUPS_FIELD));

    private final String dbInstanceIdentifier;

    private final Boolean skipFinalSnapshot;

    private final String finalDBSnapshotIdentifier;

    private final Boolean deleteAutomatedBackups;

    private DeleteDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.skipFinalSnapshot = builder.skipFinalSnapshot;
        this.finalDBSnapshotIdentifier = builder.finalDBSnapshotIdentifier;
        this.deleteAutomatedBackups = builder.deleteAutomatedBackups;
    }

    /**
     * <p>
     * The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the name of an existing DB instance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the name of an existing DB instance.
     *         </p>
     *         </li>
     */
    public String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * A value that indicates whether to skip the creation of a final DB snapshot before the DB instance is deleted. If
     * skip is specified, no DB snapshot is created. If skip isn't specified, a DB snapshot is created before the DB
     * instance is deleted. By default, skip isn't specified, and the DB snapshot is created.
     * </p>
     * <p>
     * When a DB instance is in a failure state and has a status of 'failed', 'incompatible-restore', or
     * 'incompatible-network', it can only be deleted when skip is specified.
     * </p>
     * <p>
     * Specify skip when deleting a read replica.
     * </p>
     * <note>
     * <p>
     * The FinalDBSnapshotIdentifier parameter must be specified if skip isn't specified.
     * </p>
     * </note>
     * 
     * @return A value that indicates whether to skip the creation of a final DB snapshot before the DB instance is
     *         deleted. If skip is specified, no DB snapshot is created. If skip isn't specified, a DB snapshot is
     *         created before the DB instance is deleted. By default, skip isn't specified, and the DB snapshot is
     *         created.</p>
     *         <p>
     *         When a DB instance is in a failure state and has a status of 'failed', 'incompatible-restore', or
     *         'incompatible-network', it can only be deleted when skip is specified.
     *         </p>
     *         <p>
     *         Specify skip when deleting a read replica.
     *         </p>
     *         <note>
     *         <p>
     *         The FinalDBSnapshotIdentifier parameter must be specified if skip isn't specified.
     *         </p>
     */
    public Boolean skipFinalSnapshot() {
        return skipFinalSnapshot;
    }

    /**
     * <p>
     * The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the
     * <code>SkipFinalSnapshot</code> parameter is disabled.
     * </p>
     * <note>
     * <p>
     * Specifying this parameter and also specifying to skip final DB snapshot creation in SkipFinalShapshot results in
     * an error.
     * </p>
     * </note>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 255 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be specified when deleting a read replica.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the
     *         <code>SkipFinalSnapshot</code> parameter is disabled. </p> <note>
     *         <p>
     *         Specifying this parameter and also specifying to skip final DB snapshot creation in SkipFinalShapshot
     *         results in an error.
     *         </p>
     *         </note>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 255 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be specified when deleting a read replica.
     *         </p>
     *         </li>
     */
    public String finalDBSnapshotIdentifier() {
        return finalDBSnapshotIdentifier;
    }

    /**
     * <p>
     * A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This
     * parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is
     * deleted.
     * </p>
     * 
     * @return A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
     *         This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB
     *         instance is deleted.
     */
    public Boolean deleteAutomatedBackups() {
        return deleteAutomatedBackups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(skipFinalSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(finalDBSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAutomatedBackups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbInstanceRequest)) {
            return false;
        }
        DeleteDbInstanceRequest other = (DeleteDbInstanceRequest) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(skipFinalSnapshot(), other.skipFinalSnapshot())
                && Objects.equals(finalDBSnapshotIdentifier(), other.finalDBSnapshotIdentifier())
                && Objects.equals(deleteAutomatedBackups(), other.deleteAutomatedBackups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteDbInstanceRequest").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("SkipFinalSnapshot", skipFinalSnapshot()).add("FinalDBSnapshotIdentifier", finalDBSnapshotIdentifier())
                .add("DeleteAutomatedBackups", deleteAutomatedBackups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "SkipFinalSnapshot":
            return Optional.ofNullable(clazz.cast(skipFinalSnapshot()));
        case "FinalDBSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(finalDBSnapshotIdentifier()));
        case "DeleteAutomatedBackups":
            return Optional.ofNullable(clazz.cast(deleteAutomatedBackups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbInstanceRequest, T> g) {
        return obj -> g.apply((DeleteDbInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDbInstanceRequest> {
        /**
         * <p>
         * The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the name of an existing DB instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbInstanceIdentifier
         *        The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the name of an existing DB instance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * A value that indicates whether to skip the creation of a final DB snapshot before the DB instance is deleted.
         * If skip is specified, no DB snapshot is created. If skip isn't specified, a DB snapshot is created before the
         * DB instance is deleted. By default, skip isn't specified, and the DB snapshot is created.
         * </p>
         * <p>
         * When a DB instance is in a failure state and has a status of 'failed', 'incompatible-restore', or
         * 'incompatible-network', it can only be deleted when skip is specified.
         * </p>
         * <p>
         * Specify skip when deleting a read replica.
         * </p>
         * <note>
         * <p>
         * The FinalDBSnapshotIdentifier parameter must be specified if skip isn't specified.
         * </p>
         * </note>
         * 
         * @param skipFinalSnapshot
         *        A value that indicates whether to skip the creation of a final DB snapshot before the DB instance is
         *        deleted. If skip is specified, no DB snapshot is created. If skip isn't specified, a DB snapshot is
         *        created before the DB instance is deleted. By default, skip isn't specified, and the DB snapshot is
         *        created.</p>
         *        <p>
         *        When a DB instance is in a failure state and has a status of 'failed', 'incompatible-restore', or
         *        'incompatible-network', it can only be deleted when skip is specified.
         *        </p>
         *        <p>
         *        Specify skip when deleting a read replica.
         *        </p>
         *        <note>
         *        <p>
         *        The FinalDBSnapshotIdentifier parameter must be specified if skip isn't specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipFinalSnapshot(Boolean skipFinalSnapshot);

        /**
         * <p>
         * The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the
         * <code>SkipFinalSnapshot</code> parameter is disabled.
         * </p>
         * <note>
         * <p>
         * Specifying this parameter and also specifying to skip final DB snapshot creation in SkipFinalShapshot results
         * in an error.
         * </p>
         * </note>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 255 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be specified when deleting a read replica.
         * </p>
         * </li>
         * </ul>
         * 
         * @param finalDBSnapshotIdentifier
         *        The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the
         *        <code>SkipFinalSnapshot</code> parameter is disabled. </p> <note>
         *        <p>
         *        Specifying this parameter and also specifying to skip final DB snapshot creation in SkipFinalShapshot
         *        results in an error.
         *        </p>
         *        </note>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 255 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be specified when deleting a read replica.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier);

        /**
         * <p>
         * A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This
         * parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance
         * is deleted.
         * </p>
         * 
         * @param deleteAutomatedBackups
         *        A value that indicates whether to remove automated backups immediately after the DB instance is
         *        deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately
         *        after the DB instance is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private Boolean skipFinalSnapshot;

        private String finalDBSnapshotIdentifier;

        private Boolean deleteAutomatedBackups;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbInstanceRequest model) {
            super(model);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            skipFinalSnapshot(model.skipFinalSnapshot);
            finalDBSnapshotIdentifier(model.finalDBSnapshotIdentifier);
            deleteAutomatedBackups(model.deleteAutomatedBackups);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Boolean getSkipFinalSnapshot() {
            return skipFinalSnapshot;
        }

        @Override
        public final Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        public final void setSkipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
        }

        public final String getFinalDBSnapshotIdentifier() {
            return finalDBSnapshotIdentifier;
        }

        @Override
        public final Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
            return this;
        }

        public final void setFinalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
        }

        public final Boolean getDeleteAutomatedBackups() {
            return deleteAutomatedBackups;
        }

        @Override
        public final Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        public final void setDeleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDbInstanceRequest build() {
            return new DeleteDbInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
