/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter input for the <code>DeleteDBInstanceAutomatedBackup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDbInstanceAutomatedBackupRequest extends RdsRequest implements
        ToCopyableBuilder<DeleteDbInstanceAutomatedBackupRequest.Builder, DeleteDbInstanceAutomatedBackupRequest> {
    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteDbInstanceAutomatedBackupRequest::dbiResourceId)).setter(setter(Builder::dbiResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DBI_RESOURCE_ID_FIELD));

    private final String dbiResourceId;

    private DeleteDbInstanceAutomatedBackupRequest(BuilderImpl builder) {
        super(builder);
        this.dbiResourceId = builder.dbiResourceId;
    }

    /**
     * <p>
     * The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.
     * </p>
     * 
     * @return The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.
     */
    public String dbiResourceId() {
        return dbiResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbiResourceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbInstanceAutomatedBackupRequest)) {
            return false;
        }
        DeleteDbInstanceAutomatedBackupRequest other = (DeleteDbInstanceAutomatedBackupRequest) obj;
        return Objects.equals(dbiResourceId(), other.dbiResourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteDbInstanceAutomatedBackupRequest").add("DbiResourceId", dbiResourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DbiResourceId":
            return Optional.ofNullable(clazz.cast(dbiResourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbInstanceAutomatedBackupRequest, T> g) {
        return obj -> g.apply((DeleteDbInstanceAutomatedBackupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteDbInstanceAutomatedBackupRequest> {
        /**
         * <p>
         * The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.
         * </p>
         * 
         * @param dbiResourceId
         *        The identifier for the source DB instance, which can't be changed and which is unique to an AWS
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbiResourceId(String dbiResourceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbiResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbInstanceAutomatedBackupRequest model) {
            super(model);
            dbiResourceId(model.dbiResourceId);
        }

        public final String getDbiResourceId() {
            return dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDbInstanceAutomatedBackupRequest build() {
            return new DeleteDbInstanceAutomatedBackupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
