/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCustomAvailabilityZoneRequest extends RdsRequest implements
        ToCopyableBuilder<DeleteCustomAvailabilityZoneRequest.Builder, DeleteCustomAvailabilityZoneRequest> {
    private static final SdkField<String> CUSTOM_AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteCustomAvailabilityZoneRequest::customAvailabilityZoneId))
            .setter(setter(Builder::customAvailabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZoneId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CUSTOM_AVAILABILITY_ZONE_ID_FIELD));

    private final String customAvailabilityZoneId;

    private DeleteCustomAvailabilityZoneRequest(BuilderImpl builder) {
        super(builder);
        this.customAvailabilityZoneId = builder.customAvailabilityZoneId;
    }

    /**
     * <p>
     * The custom AZ identifier.
     * </p>
     * 
     * @return The custom AZ identifier.
     */
    public String customAvailabilityZoneId() {
        return customAvailabilityZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customAvailabilityZoneId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomAvailabilityZoneRequest)) {
            return false;
        }
        DeleteCustomAvailabilityZoneRequest other = (DeleteCustomAvailabilityZoneRequest) obj;
        return Objects.equals(customAvailabilityZoneId(), other.customAvailabilityZoneId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteCustomAvailabilityZoneRequest")
                .add("CustomAvailabilityZoneId", customAvailabilityZoneId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomAvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(customAvailabilityZoneId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCustomAvailabilityZoneRequest, T> g) {
        return obj -> g.apply((DeleteCustomAvailabilityZoneRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteCustomAvailabilityZoneRequest> {
        /**
         * <p>
         * The custom AZ identifier.
         * </p>
         * 
         * @param customAvailabilityZoneId
         *        The custom AZ identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAvailabilityZoneId(String customAvailabilityZoneId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String customAvailabilityZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomAvailabilityZoneRequest model) {
            super(model);
            customAvailabilityZoneId(model.customAvailabilityZoneId);
        }

        public final String getCustomAvailabilityZoneId() {
            return customAvailabilityZoneId;
        }

        @Override
        public final Builder customAvailabilityZoneId(String customAvailabilityZoneId) {
            this.customAvailabilityZoneId = customAvailabilityZoneId;
            return this;
        }

        public final void setCustomAvailabilityZoneId(String customAvailabilityZoneId) {
            this.customAvailabilityZoneId = customAvailabilityZoneId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCustomAvailabilityZoneRequest build() {
            return new DeleteCustomAvailabilityZoneRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
