/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the DB parameter group.
 * </p>
 * <p>
 * This data type is used as a response element in the following actions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>CreateDBInstance</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CreateDBInstanceReadReplica</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DeleteDBInstance</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ModifyDBInstance</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RebootDBInstance</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RestoreDBInstanceFromDBSnapshot</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBParameterGroupStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<DBParameterGroupStatus.Builder, DBParameterGroupStatus> {
    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBParameterGroupStatus::dbParameterGroupName)).setter(setter(Builder::dbParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build())
            .build();

    private static final SdkField<String> PARAMETER_APPLY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBParameterGroupStatus::parameterApplyStatus)).setter(setter(Builder::parameterApplyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PARAMETER_GROUP_NAME_FIELD,
            PARAMETER_APPLY_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbParameterGroupName;

    private final String parameterApplyStatus;

    private DBParameterGroupStatus(BuilderImpl builder) {
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
    }

    /**
     * <p>
     * The name of the DB parameter group.
     * </p>
     * 
     * @return The name of the DB parameter group.
     */
    public String dbParameterGroupName() {
        return dbParameterGroupName;
    }

    /**
     * <p>
     * The status of parameter updates.
     * </p>
     * 
     * @return The status of parameter updates.
     */
    public String parameterApplyStatus() {
        return parameterApplyStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterApplyStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBParameterGroupStatus)) {
            return false;
        }
        DBParameterGroupStatus other = (DBParameterGroupStatus) obj;
        return Objects.equals(dbParameterGroupName(), other.dbParameterGroupName())
                && Objects.equals(parameterApplyStatus(), other.parameterApplyStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DBParameterGroupStatus").add("DBParameterGroupName", dbParameterGroupName())
                .add("ParameterApplyStatus", parameterApplyStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbParameterGroupName()));
        case "ParameterApplyStatus":
            return Optional.ofNullable(clazz.cast(parameterApplyStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBParameterGroupStatus, T> g) {
        return obj -> g.apply((DBParameterGroupStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBParameterGroupStatus> {
        /**
         * <p>
         * The name of the DB parameter group.
         * </p>
         * 
         * @param dbParameterGroupName
         *        The name of the DB parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupName(String dbParameterGroupName);

        /**
         * <p>
         * The status of parameter updates.
         * </p>
         * 
         * @param parameterApplyStatus
         *        The status of parameter updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterApplyStatus(String parameterApplyStatus);
    }

    static final class BuilderImpl implements Builder {
        private String dbParameterGroupName;

        private String parameterApplyStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DBParameterGroupStatus model) {
            dbParameterGroupName(model.dbParameterGroupName);
            parameterApplyStatus(model.parameterApplyStatus);
        }

        public final String getDbParameterGroupName() {
            return dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        public final String getParameterApplyStatus() {
            return parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        @Override
        public DBParameterGroupStatus build() {
            return new DBParameterGroupStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
