/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An automated backup of a DB instance. It it consists of system backups, transaction logs, and the database instance
 * properties that existed at the time you deleted the source instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBInstanceAutomatedBackup implements SdkPojo, Serializable,
        ToCopyableBuilder<DBInstanceAutomatedBackup.Builder, DBInstanceAutomatedBackup> {
    private static final SdkField<String> DB_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::dbInstanceArn)).setter(setter(Builder::dbInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceArn").build()).build();

    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::dbiResourceId)).setter(setter(Builder::dbiResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::dbInstanceIdentifier)).setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<RestoreWindow> RESTORE_WINDOW_FIELD = SdkField
            .<RestoreWindow> builder(MarshallingType.SDK_POJO).getter(getter(DBInstanceAutomatedBackup::restoreWindow))
            .setter(setter(Builder::restoreWindow)).constructor(RestoreWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreWindow").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DBInstanceAutomatedBackup::allocatedStorage)).setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DBInstanceAutomatedBackup::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<Instant> INSTANCE_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DBInstanceAutomatedBackup::instanceCreateTime)).setter(setter(Builder::instanceCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build())
            .build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::masterUsername)).setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::licenseModel)).setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DBInstanceAutomatedBackup::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::optionGroupName)).setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::tdeCredentialArn)).setter(setter(Builder::tdeCredentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DBInstanceAutomatedBackup::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBInstanceAutomatedBackup::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DBInstanceAutomatedBackup::iamDatabaseAuthenticationEnabled))
            .setter(setter(Builder::iamDatabaseAuthenticationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_ARN_FIELD,
            DBI_RESOURCE_ID_FIELD, REGION_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, RESTORE_WINDOW_FIELD, ALLOCATED_STORAGE_FIELD,
            STATUS_FIELD, PORT_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ID_FIELD, INSTANCE_CREATE_TIME_FIELD, MASTER_USERNAME_FIELD,
            ENGINE_FIELD, ENGINE_VERSION_FIELD, LICENSE_MODEL_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD,
            TDE_CREDENTIAL_ARN_FIELD, ENCRYPTED_FIELD, STORAGE_TYPE_FIELD, KMS_KEY_ID_FIELD, TIMEZONE_FIELD,
            IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbInstanceArn;

    private final String dbiResourceId;

    private final String region;

    private final String dbInstanceIdentifier;

    private final RestoreWindow restoreWindow;

    private final Integer allocatedStorage;

    private final String status;

    private final Integer port;

    private final String availabilityZone;

    private final String vpcId;

    private final Instant instanceCreateTime;

    private final String masterUsername;

    private final String engine;

    private final String engineVersion;

    private final String licenseModel;

    private final Integer iops;

    private final String optionGroupName;

    private final String tdeCredentialArn;

    private final Boolean encrypted;

    private final String storageType;

    private final String kmsKeyId;

    private final String timezone;

    private final Boolean iamDatabaseAuthenticationEnabled;

    private DBInstanceAutomatedBackup(BuilderImpl builder) {
        this.dbInstanceArn = builder.dbInstanceArn;
        this.dbiResourceId = builder.dbiResourceId;
        this.region = builder.region;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.restoreWindow = builder.restoreWindow;
        this.allocatedStorage = builder.allocatedStorage;
        this.status = builder.status;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.masterUsername = builder.masterUsername;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.encrypted = builder.encrypted;
        this.storageType = builder.storageType;
        this.kmsKeyId = builder.kmsKeyId;
        this.timezone = builder.timezone;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the automated backup.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the automated backup.
     */
    public String dbInstanceArn() {
        return dbInstanceArn;
    }

    /**
     * <p>
     * The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.
     * </p>
     * 
     * @return The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.
     */
    public String dbiResourceId() {
        return dbiResourceId;
    }

    /**
     * <p>
     * The AWS Region associated with the automated backup.
     * </p>
     * 
     * @return The AWS Region associated with the automated backup.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The customer id of the instance that is/was associated with the automated backup.
     * </p>
     * 
     * @return The customer id of the instance that is/was associated with the automated backup.
     */
    public String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * Earliest and latest time an instance can be restored to.
     * </p>
     * 
     * @return Earliest and latest time an instance can be restored to.
     */
    public RestoreWindow restoreWindow() {
        return restoreWindow;
    }

    /**
     * <p>
     * Specifies the allocated storage size in gibibytes (GiB).
     * </p>
     * 
     * @return Specifies the allocated storage size in gibibytes (GiB).
     */
    public Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * Provides a list of status information for an automated backup:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code> - automated backups for current instances
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>retained</code> - automated backups for deleted instances
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Provides a list of status information for an automated backup:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code> - automated backups for current instances
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>retained</code> - automated backups for deleted instances
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>creating</code> - automated backups that are waiting for the first automated snapshot to be
     *         available.
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The port number that the automated backup used for connections.
     * </p>
     * <p>
     * Default: Inherits from the source DB instance
     * </p>
     * <p>
     * Valid Values: <code>1150-65535</code>
     * </p>
     * 
     * @return The port number that the automated backup used for connections.</p>
     *         <p>
     *         Default: Inherits from the source DB instance
     *         </p>
     *         <p>
     *         Valid Values: <code>1150-65535</code>
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * The Availability Zone that the automated backup was created in. For information on AWS Regions and Availability
     * Zones, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions
     * and Availability Zones</a>.
     * </p>
     * 
     * @return The Availability Zone that the automated backup was created in. For information on AWS Regions and
     *         Availability Zones, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
     *         >Regions and Availability Zones</a>.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Provides the VPC ID associated with the DB instance
     * </p>
     * 
     * @return Provides the VPC ID associated with the DB instance
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Provides the date and time that the DB instance was created.
     * </p>
     * 
     * @return Provides the date and time that the DB instance was created.
     */
    public Instant instanceCreateTime() {
        return instanceCreateTime;
    }

    /**
     * <p>
     * The license model of an automated backup.
     * </p>
     * 
     * @return The license model of an automated backup.
     */
    public String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The name of the database engine for this automated backup.
     * </p>
     * 
     * @return The name of the database engine for this automated backup.
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * The version of the database engine for the automated backup.
     * </p>
     * 
     * @return The version of the database engine for the automated backup.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * License model information for the automated backup.
     * </p>
     * 
     * @return License model information for the automated backup.
     */
    public String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * The IOPS (I/O operations per second) value for the automated backup.
     * </p>
     * 
     * @return The IOPS (I/O operations per second) value for the automated backup.
     */
    public Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The option group the automated backup is associated with. If omitted, the default option group for the engine
     * specified is used.
     * </p>
     * 
     * @return The option group the automated backup is associated with. If omitted, the default option group for the
     *         engine specified is used.
     */
    public String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * The ARN from the key store with which the automated backup is associated for TDE encryption.
     * </p>
     * 
     * @return The ARN from the key store with which the automated backup is associated for TDE encryption.
     */
    public String tdeCredentialArn() {
        return tdeCredentialArn;
    }

    /**
     * <p>
     * Specifies whether the automated backup is encrypted.
     * </p>
     * 
     * @return Specifies whether the automated backup is encrypted.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * Specifies the storage type associated with the automated backup.
     * </p>
     * 
     * @return Specifies the storage type associated with the automated backup.
     */
    public String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The AWS KMS key ID for an automated backup. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier,
     * or the KMS key alias for the KMS encryption key.
     * </p>
     * 
     * @return The AWS KMS key ID for an automated backup. The KMS key ID is the Amazon Resource Name (ARN), KMS key
     *         identifier, or the KMS key alias for the KMS encryption key.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty.
     * <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time
     * zone specified.
     * </p>
     * 
     * @return The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty.
     *         <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a
     *         time zone specified.
     */
    public String timezone() {
        return timezone;
    }

    /**
     * <p>
     * True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and
     * otherwise false.
     * </p>
     * 
     * @return True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and
     *         otherwise false.
     */
    public Boolean iamDatabaseAuthenticationEnabled() {
        return iamDatabaseAuthenticationEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(restoreWindow());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(iamDatabaseAuthenticationEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstanceAutomatedBackup)) {
            return false;
        }
        DBInstanceAutomatedBackup other = (DBInstanceAutomatedBackup) obj;
        return Objects.equals(dbInstanceArn(), other.dbInstanceArn()) && Objects.equals(dbiResourceId(), other.dbiResourceId())
                && Objects.equals(region(), other.region())
                && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(restoreWindow(), other.restoreWindow())
                && Objects.equals(allocatedStorage(), other.allocatedStorage()) && Objects.equals(status(), other.status())
                && Objects.equals(port(), other.port()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(instanceCreateTime(), other.instanceCreateTime())
                && Objects.equals(masterUsername(), other.masterUsername()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(licenseModel(), other.licenseModel())
                && Objects.equals(iops(), other.iops()) && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(tdeCredentialArn(), other.tdeCredentialArn()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(storageType(), other.storageType()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(timezone(), other.timezone())
                && Objects.equals(iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DBInstanceAutomatedBackup").add("DBInstanceArn", dbInstanceArn())
                .add("DbiResourceId", dbiResourceId()).add("Region", region())
                .add("DBInstanceIdentifier", dbInstanceIdentifier()).add("RestoreWindow", restoreWindow())
                .add("AllocatedStorage", allocatedStorage()).add("Status", status()).add("Port", port())
                .add("AvailabilityZone", availabilityZone()).add("VpcId", vpcId())
                .add("InstanceCreateTime", instanceCreateTime()).add("MasterUsername", masterUsername()).add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("LicenseModel", licenseModel()).add("Iops", iops())
                .add("OptionGroupName", optionGroupName()).add("TdeCredentialArn", tdeCredentialArn())
                .add("Encrypted", encrypted()).add("StorageType", storageType()).add("KmsKeyId", kmsKeyId())
                .add("Timezone", timezone()).add("IAMDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceArn":
            return Optional.ofNullable(clazz.cast(dbInstanceArn()));
        case "DbiResourceId":
            return Optional.ofNullable(clazz.cast(dbiResourceId()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "RestoreWindow":
            return Optional.ofNullable(clazz.cast(restoreWindow()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "InstanceCreateTime":
            return Optional.ofNullable(clazz.cast(instanceCreateTime()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "TdeCredentialArn":
            return Optional.ofNullable(clazz.cast(tdeCredentialArn()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "IAMDatabaseAuthenticationEnabled":
            return Optional.ofNullable(clazz.cast(iamDatabaseAuthenticationEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBInstanceAutomatedBackup, T> g) {
        return obj -> g.apply((DBInstanceAutomatedBackup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBInstanceAutomatedBackup> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the automated backup.
         * </p>
         * 
         * @param dbInstanceArn
         *        The Amazon Resource Name (ARN) for the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceArn(String dbInstanceArn);

        /**
         * <p>
         * The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.
         * </p>
         * 
         * @param dbiResourceId
         *        The identifier for the source DB instance, which can't be changed and which is unique to an AWS
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbiResourceId(String dbiResourceId);

        /**
         * <p>
         * The AWS Region associated with the automated backup.
         * </p>
         * 
         * @param region
         *        The AWS Region associated with the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The customer id of the instance that is/was associated with the automated backup.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The customer id of the instance that is/was associated with the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * Earliest and latest time an instance can be restored to.
         * </p>
         * 
         * @param restoreWindow
         *        Earliest and latest time an instance can be restored to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreWindow(RestoreWindow restoreWindow);

        /**
         * <p>
         * Earliest and latest time an instance can be restored to.
         * </p>
         * This is a convenience that creates an instance of the {@link RestoreWindow.Builder} avoiding the need to
         * create one manually via {@link RestoreWindow#builder()}.
         *
         * When the {@link Consumer} completes, {@link RestoreWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #restoreWindow(RestoreWindow)}.
         * 
         * @param restoreWindow
         *        a consumer that will call methods on {@link RestoreWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreWindow(RestoreWindow)
         */
        default Builder restoreWindow(Consumer<RestoreWindow.Builder> restoreWindow) {
            return restoreWindow(RestoreWindow.builder().applyMutation(restoreWindow).build());
        }

        /**
         * <p>
         * Specifies the allocated storage size in gibibytes (GiB).
         * </p>
         * 
         * @param allocatedStorage
         *        Specifies the allocated storage size in gibibytes (GiB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * Provides a list of status information for an automated backup:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - automated backups for current instances
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>retained</code> - automated backups for deleted instances
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Provides a list of status information for an automated backup:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - automated backups for current instances
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>retained</code> - automated backups for deleted instances
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>creating</code> - automated backups that are waiting for the first automated snapshot to be
         *        available.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The port number that the automated backup used for connections.
         * </p>
         * <p>
         * Default: Inherits from the source DB instance
         * </p>
         * <p>
         * Valid Values: <code>1150-65535</code>
         * </p>
         * 
         * @param port
         *        The port number that the automated backup used for connections.</p>
         *        <p>
         *        Default: Inherits from the source DB instance
         *        </p>
         *        <p>
         *        Valid Values: <code>1150-65535</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The Availability Zone that the automated backup was created in. For information on AWS Regions and
         * Availability Zones, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
         * >Regions and Availability Zones</a>.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone that the automated backup was created in. For information on AWS Regions and
         *        Availability Zones, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
         *        >Regions and Availability Zones</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Provides the VPC ID associated with the DB instance
         * </p>
         * 
         * @param vpcId
         *        Provides the VPC ID associated with the DB instance
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Provides the date and time that the DB instance was created.
         * </p>
         * 
         * @param instanceCreateTime
         *        Provides the date and time that the DB instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCreateTime(Instant instanceCreateTime);

        /**
         * <p>
         * The license model of an automated backup.
         * </p>
         * 
         * @param masterUsername
         *        The license model of an automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The name of the database engine for this automated backup.
         * </p>
         * 
         * @param engine
         *        The name of the database engine for this automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version of the database engine for the automated backup.
         * </p>
         * 
         * @param engineVersion
         *        The version of the database engine for the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * License model information for the automated backup.
         * </p>
         * 
         * @param licenseModel
         *        License model information for the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The IOPS (I/O operations per second) value for the automated backup.
         * </p>
         * 
         * @param iops
         *        The IOPS (I/O operations per second) value for the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The option group the automated backup is associated with. If omitted, the default option group for the engine
         * specified is used.
         * </p>
         * 
         * @param optionGroupName
         *        The option group the automated backup is associated with. If omitted, the default option group for the
         *        engine specified is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * The ARN from the key store with which the automated backup is associated for TDE encryption.
         * </p>
         * 
         * @param tdeCredentialArn
         *        The ARN from the key store with which the automated backup is associated for TDE encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialArn(String tdeCredentialArn);

        /**
         * <p>
         * Specifies whether the automated backup is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Specifies whether the automated backup is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * Specifies the storage type associated with the automated backup.
         * </p>
         * 
         * @param storageType
         *        Specifies the storage type associated with the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The AWS KMS key ID for an automated backup. The KMS key ID is the Amazon Resource Name (ARN), KMS key
         * identifier, or the KMS key alias for the KMS encryption key.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS KMS key ID for an automated backup. The KMS key ID is the Amazon Resource Name (ARN), KMS key
         *        identifier, or the KMS key alias for the KMS encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty.
         * <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a
         * time zone specified.
         * </p>
         * 
         * @param timezone
         *        The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty.
         *        <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created
         *        with a time zone specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and
         * otherwise false.
         * </p>
         * 
         * @param iamDatabaseAuthenticationEnabled
         *        True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled,
         *        and otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String dbInstanceArn;

        private String dbiResourceId;

        private String region;

        private String dbInstanceIdentifier;

        private RestoreWindow restoreWindow;

        private Integer allocatedStorage;

        private String status;

        private Integer port;

        private String availabilityZone;

        private String vpcId;

        private Instant instanceCreateTime;

        private String masterUsername;

        private String engine;

        private String engineVersion;

        private String licenseModel;

        private Integer iops;

        private String optionGroupName;

        private String tdeCredentialArn;

        private Boolean encrypted;

        private String storageType;

        private String kmsKeyId;

        private String timezone;

        private Boolean iamDatabaseAuthenticationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DBInstanceAutomatedBackup model) {
            dbInstanceArn(model.dbInstanceArn);
            dbiResourceId(model.dbiResourceId);
            region(model.region);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            restoreWindow(model.restoreWindow);
            allocatedStorage(model.allocatedStorage);
            status(model.status);
            port(model.port);
            availabilityZone(model.availabilityZone);
            vpcId(model.vpcId);
            instanceCreateTime(model.instanceCreateTime);
            masterUsername(model.masterUsername);
            engine(model.engine);
            engineVersion(model.engineVersion);
            licenseModel(model.licenseModel);
            iops(model.iops);
            optionGroupName(model.optionGroupName);
            tdeCredentialArn(model.tdeCredentialArn);
            encrypted(model.encrypted);
            storageType(model.storageType);
            kmsKeyId(model.kmsKeyId);
            timezone(model.timezone);
            iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
        }

        public final String getDbInstanceArn() {
            return dbInstanceArn;
        }

        @Override
        public final Builder dbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
            return this;
        }

        public final void setDbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
        }

        public final String getDbiResourceId() {
            return dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final RestoreWindow.Builder getRestoreWindow() {
            return restoreWindow != null ? restoreWindow.toBuilder() : null;
        }

        @Override
        public final Builder restoreWindow(RestoreWindow restoreWindow) {
            this.restoreWindow = restoreWindow;
            return this;
        }

        public final void setRestoreWindow(RestoreWindow.BuilderImpl restoreWindow) {
            this.restoreWindow = restoreWindow != null ? restoreWindow.build() : null;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Instant getInstanceCreateTime() {
            return instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final void setInstanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getTdeCredentialArn() {
            return tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getStorageType() {
            return storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        public DBInstanceAutomatedBackup build() {
            return new DBInstanceAutomatedBackup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
