/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstance;

public class DescribeReservedDBInstancesPublisher
implements SdkPublisher<DescribeReservedDbInstancesResponse> {
    private final RdsAsyncClient client;
    private final DescribeReservedDbInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedDBInstancesPublisher(RdsAsyncClient client, DescribeReservedDbInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedDBInstancesPublisher(RdsAsyncClient client, DescribeReservedDbInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedDbInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedDbInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservedDBInstance> reservedDBInstances() {
        Function<DescribeReservedDbInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedDBInstances() != null) {
                return response.reservedDBInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeReservedDbInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeReservedDbInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeReservedDbInstancesResponse> {
        private DescribeReservedDbInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedDbInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReservedDbInstancesResponse> nextPage(DescribeReservedDbInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedDBInstancesPublisher.this.client.describeReservedDBInstances(DescribeReservedDBInstancesPublisher.this.firstRequest);
            }
            return DescribeReservedDBInstancesPublisher.this.client.describeReservedDBInstances((DescribeReservedDbInstancesRequest)((Object)DescribeReservedDBInstancesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

