/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup;
import software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbInstanceAutomatedBackupsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbInstanceAutomatedBackupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbInstanceAutomatedBackupsResponse.getter(DescribeDbInstanceAutomatedBackupsResponse::marker)).setter(DescribeDbInstanceAutomatedBackupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBInstanceAutomatedBackup>> DB_INSTANCE_AUTOMATED_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDbInstanceAutomatedBackupsResponse.getter(DescribeDbInstanceAutomatedBackupsResponse::dbInstanceAutomatedBackups)).setter(DescribeDbInstanceAutomatedBackupsResponse.setter(Builder::dbInstanceAutomatedBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceAutomatedBackups").build(), ListTrait.builder().memberLocationName("DBInstanceAutomatedBackup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBInstanceAutomatedBackup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceAutomatedBackup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_INSTANCE_AUTOMATED_BACKUPS_FIELD));
    private final String marker;
    private final List<DBInstanceAutomatedBackup> dbInstanceAutomatedBackups;

    private DescribeDbInstanceAutomatedBackupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbInstanceAutomatedBackups = builder.dbInstanceAutomatedBackups;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBInstanceAutomatedBackup> dbInstanceAutomatedBackups() {
        return this.dbInstanceAutomatedBackups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceAutomatedBackups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbInstanceAutomatedBackupsResponse)) {
            return false;
        }
        DescribeDbInstanceAutomatedBackupsResponse other = (DescribeDbInstanceAutomatedBackupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbInstanceAutomatedBackups(), other.dbInstanceAutomatedBackups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbInstanceAutomatedBackupsResponse").add("Marker", (Object)this.marker()).add("DBInstanceAutomatedBackups", this.dbInstanceAutomatedBackups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBInstanceAutomatedBackups": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceAutomatedBackups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbInstanceAutomatedBackupsResponse, T> g) {
        return obj -> g.apply((DescribeDbInstanceAutomatedBackupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBInstanceAutomatedBackup> dbInstanceAutomatedBackups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbInstanceAutomatedBackupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbInstanceAutomatedBackups(model.dbInstanceAutomatedBackups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBInstanceAutomatedBackup.Builder> getDBInstanceAutomatedBackups() {
            return this.dbInstanceAutomatedBackups != null ? (Collection)this.dbInstanceAutomatedBackups.stream().map(DBInstanceAutomatedBackup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbInstanceAutomatedBackups(Collection<DBInstanceAutomatedBackup> dbInstanceAutomatedBackups) {
            this.dbInstanceAutomatedBackups = DBInstanceAutomatedBackupListCopier.copy(dbInstanceAutomatedBackups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstanceAutomatedBackups(DBInstanceAutomatedBackup ... dbInstanceAutomatedBackups) {
            this.dbInstanceAutomatedBackups(Arrays.asList(dbInstanceAutomatedBackups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstanceAutomatedBackups(Consumer<DBInstanceAutomatedBackup.Builder> ... dbInstanceAutomatedBackups) {
            this.dbInstanceAutomatedBackups(Stream.of(dbInstanceAutomatedBackups).map(c -> (DBInstanceAutomatedBackup)((DBInstanceAutomatedBackup.Builder)DBInstanceAutomatedBackup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDBInstanceAutomatedBackups(Collection<DBInstanceAutomatedBackup.BuilderImpl> dbInstanceAutomatedBackups) {
            this.dbInstanceAutomatedBackups = DBInstanceAutomatedBackupListCopier.copyFromBuilder(dbInstanceAutomatedBackups);
        }

        @Override
        public DescribeDbInstanceAutomatedBackupsResponse build() {
            return new DescribeDbInstanceAutomatedBackupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbInstanceAutomatedBackupsResponse> {
        public Builder marker(String var1);

        public Builder dbInstanceAutomatedBackups(Collection<DBInstanceAutomatedBackup> var1);

        public Builder dbInstanceAutomatedBackups(DBInstanceAutomatedBackup ... var1);

        public Builder dbInstanceAutomatedBackups(Consumer<DBInstanceAutomatedBackup.Builder> ... var1);
    }
}

