/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.ProcessorFeature;
import software.amazon.awssdk.services.rds.model.ProcessorFeatureListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDbInstanceReadReplicaRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CreateDbInstanceReadReplicaRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::dbInstanceIdentifier)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::sourceDBInstanceIdentifier)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::sourceDBInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBInstanceIdentifier").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::dbInstanceClass)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::availabilityZone)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::port)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::multiAZ)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::autoMinorVersionUpgrade)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::iops)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::optionGroupName)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::publiclyAccessible)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::tags)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::dbSubnetGroupName)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::dbSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::storageType)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::copyTagsToSnapshot)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::monitoringInterval)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::monitoringInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build()}).build();
    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::monitoringRoleArn)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::monitoringRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::kmsKeyId)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::preSignedUrl)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::preSignedUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()}).build();
    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::enableIAMDatabaseAuthentication)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::enableIAMDatabaseAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication").build()}).build();
    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::enablePerformanceInsights)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::enablePerformanceInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build()}).build();
    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::performanceInsightsKMSKeyId)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::performanceInsightsKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId").build()}).build();
    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::performanceInsightsRetentionPeriod)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::performanceInsightsRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod").build()}).build();
    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::enableCloudwatchLogsExports)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::enableCloudwatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::processorFeatures)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::processorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(), ListTrait.builder().memberLocationName("ProcessorFeature").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessorFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeature").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_DEFAULT_PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::useDefaultProcessorFeatures)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::useDefaultProcessorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDefaultProcessorFeatures").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::deletionProtection)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::sourceRegion)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD, SOURCE_DB_INSTANCE_IDENTIFIER_FIELD, DB_INSTANCE_CLASS_FIELD, AVAILABILITY_ZONE_FIELD, PORT_FIELD, MULTI_AZ_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD, PUBLICLY_ACCESSIBLE_FIELD, TAGS_FIELD, DB_SUBNET_GROUP_NAME_FIELD, STORAGE_TYPE_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, PRE_SIGNED_URL_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD, PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, PROCESSOR_FEATURES_FIELD, USE_DEFAULT_PROCESSOR_FEATURES_FIELD, DELETION_PROTECTION_FIELD, SOURCE_REGION_FIELD));
    private final String dbInstanceIdentifier;
    private final String sourceDBInstanceIdentifier;
    private final String dbInstanceClass;
    private final String availabilityZone;
    private final Integer port;
    private final Boolean multiAZ;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer iops;
    private final String optionGroupName;
    private final Boolean publiclyAccessible;
    private final List<Tag> tags;
    private final String dbSubnetGroupName;
    private final String storageType;
    private final Boolean copyTagsToSnapshot;
    private final Integer monitoringInterval;
    private final String monitoringRoleArn;
    private final String kmsKeyId;
    private final String preSignedUrl;
    private final Boolean enableIAMDatabaseAuthentication;
    private final Boolean enablePerformanceInsights;
    private final String performanceInsightsKMSKeyId;
    private final Integer performanceInsightsRetentionPeriod;
    private final List<String> enableCloudwatchLogsExports;
    private final List<ProcessorFeature> processorFeatures;
    private final Boolean useDefaultProcessorFeatures;
    private final Boolean deletionProtection;
    private final String sourceRegion;

    private CreateDbInstanceReadReplicaRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.sourceDBInstanceIdentifier = builder.sourceDBInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.availabilityZone = builder.availabilityZone;
        this.port = builder.port;
        this.multiAZ = builder.multiAZ;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.storageType = builder.storageType;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.processorFeatures = builder.processorFeatures;
        this.useDefaultProcessorFeatures = builder.useDefaultProcessorFeatures;
        this.deletionProtection = builder.deletionProtection;
        this.sourceRegion = builder.sourceRegion;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String sourceDBInstanceIdentifier() {
        return this.sourceDBInstanceIdentifier;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Integer port() {
        return this.port;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer iops() {
        return this.iops;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String storageType() {
        return this.storageType;
    }

    public Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public Integer monitoringInterval() {
        return this.monitoringInterval;
    }

    public String monitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String preSignedUrl() {
        return this.preSignedUrl;
    }

    public Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public Boolean enablePerformanceInsights() {
        return this.enablePerformanceInsights;
    }

    public String performanceInsightsKMSKeyId() {
        return this.performanceInsightsKMSKeyId;
    }

    public Integer performanceInsightsRetentionPeriod() {
        return this.performanceInsightsRetentionPeriod;
    }

    public List<String> enableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports;
    }

    public List<ProcessorFeature> processorFeatures() {
        return this.processorFeatures;
    }

    public Boolean useDefaultProcessorFeatures() {
        return this.useDefaultProcessorFeatures;
    }

    public Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCloudwatchLogsExports());
        hashCode = 31 * hashCode + Objects.hashCode(this.processorFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(this.useDefaultProcessorFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbInstanceReadReplicaRequest)) {
            return false;
        }
        CreateDbInstanceReadReplicaRequest other = (CreateDbInstanceReadReplicaRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.sourceDBInstanceIdentifier(), other.sourceDBInstanceIdentifier()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.monitoringInterval(), other.monitoringInterval()) && Objects.equals(this.monitoringRoleArn(), other.monitoringRoleArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.preSignedUrl(), other.preSignedUrl()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication()) && Objects.equals(this.enablePerformanceInsights(), other.enablePerformanceInsights()) && Objects.equals(this.performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId()) && Objects.equals(this.performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod()) && Objects.equals(this.enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports()) && Objects.equals(this.processorFeatures(), other.processorFeatures()) && Objects.equals(this.useDefaultProcessorFeatures(), other.useDefaultProcessorFeatures()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.sourceRegion(), other.sourceRegion());
    }

    public String toString() {
        return ToString.builder((String)"CreateDbInstanceReadReplicaRequest").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("SourceDBInstanceIdentifier", (Object)this.sourceDBInstanceIdentifier()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Port", (Object)this.port()).add("MultiAZ", (Object)this.multiAZ()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("Iops", (Object)this.iops()).add("OptionGroupName", (Object)this.optionGroupName()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("Tags", this.tags()).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("StorageType", (Object)this.storageType()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("MonitoringInterval", (Object)this.monitoringInterval()).add("MonitoringRoleArn", (Object)this.monitoringRoleArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PreSignedUrl", (Object)this.preSignedUrl()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).add("EnablePerformanceInsights", (Object)this.enablePerformanceInsights()).add("PerformanceInsightsKMSKeyId", (Object)this.performanceInsightsKMSKeyId()).add("PerformanceInsightsRetentionPeriod", (Object)this.performanceInsightsRetentionPeriod()).add("EnableCloudwatchLogsExports", this.enableCloudwatchLogsExports()).add("ProcessorFeatures", this.processorFeatures()).add("UseDefaultProcessorFeatures", (Object)this.useDefaultProcessorFeatures()).add("DeletionProtection", (Object)this.deletionProtection()).add("SourceRegion", (Object)this.sourceRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "SourceDBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDBInstanceIdentifier()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "MonitoringInterval": {
                return Optional.ofNullable(clazz.cast(this.monitoringInterval()));
            }
            case "MonitoringRoleArn": {
                return Optional.ofNullable(clazz.cast(this.monitoringRoleArn()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "PreSignedUrl": {
                return Optional.ofNullable(clazz.cast(this.preSignedUrl()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
            case "EnablePerformanceInsights": {
                return Optional.ofNullable(clazz.cast(this.enablePerformanceInsights()));
            }
            case "PerformanceInsightsKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsKMSKeyId()));
            }
            case "PerformanceInsightsRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsRetentionPeriod()));
            }
            case "EnableCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enableCloudwatchLogsExports()));
            }
            case "ProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.processorFeatures()));
            }
            case "UseDefaultProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.useDefaultProcessorFeatures()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbInstanceReadReplicaRequest, T> g) {
        return obj -> g.apply((CreateDbInstanceReadReplicaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String sourceDBInstanceIdentifier;
        private String dbInstanceClass;
        private String availabilityZone;
        private Integer port;
        private Boolean multiAZ;
        private Boolean autoMinorVersionUpgrade;
        private Integer iops;
        private String optionGroupName;
        private Boolean publiclyAccessible;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String dbSubnetGroupName;
        private String storageType;
        private Boolean copyTagsToSnapshot;
        private Integer monitoringInterval;
        private String monitoringRoleArn;
        private String kmsKeyId;
        private String preSignedUrl;
        private Boolean enableIAMDatabaseAuthentication;
        private Boolean enablePerformanceInsights;
        private String performanceInsightsKMSKeyId;
        private Integer performanceInsightsRetentionPeriod;
        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private List<ProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();
        private Boolean useDefaultProcessorFeatures;
        private Boolean deletionProtection;
        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbInstanceReadReplicaRequest model) {
            super(model);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.sourceDBInstanceIdentifier(model.sourceDBInstanceIdentifier);
            this.dbInstanceClass(model.dbInstanceClass);
            this.availabilityZone(model.availabilityZone);
            this.port(model.port);
            this.multiAZ(model.multiAZ);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.iops(model.iops);
            this.optionGroupName(model.optionGroupName);
            this.publiclyAccessible(model.publiclyAccessible);
            this.tags(model.tags);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.storageType(model.storageType);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.monitoringInterval(model.monitoringInterval);
            this.monitoringRoleArn(model.monitoringRoleArn);
            this.kmsKeyId(model.kmsKeyId);
            this.preSignedUrl(model.preSignedUrl);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.enablePerformanceInsights(model.enablePerformanceInsights);
            this.performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            this.performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            this.enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            this.processorFeatures(model.processorFeatures);
            this.useDefaultProcessorFeatures(model.useDefaultProcessorFeatures);
            this.deletionProtection(model.deletionProtection);
            this.sourceRegion(model.sourceRegion);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getSourceDBInstanceIdentifier() {
            return this.sourceDBInstanceIdentifier;
        }

        @Override
        public final Builder sourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
            this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
            return this;
        }

        public final void setSourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
            this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
        }

        public final String getDBInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDBInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final Integer getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        public final String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final Boolean getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return this.performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return this.performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            return this.enableCloudwatchLogsExports;
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String ... enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        public final Collection<ProcessorFeature.Builder> getProcessorFeatures() {
            return this.processorFeatures != null ? (Collection)this.processorFeatures.stream().map(ProcessorFeature::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processorFeatures(Collection<ProcessorFeature> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(ProcessorFeature ... processorFeatures) {
            this.processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... processorFeatures) {
            this.processorFeatures(Stream.of(processorFeatures).map(c -> (ProcessorFeature)((ProcessorFeature.Builder)ProcessorFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcessorFeatures(Collection<ProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copyFromBuilder(processorFeatures);
        }

        public final Boolean getUseDefaultProcessorFeatures() {
            return this.useDefaultProcessorFeatures;
        }

        @Override
        public final Builder useDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
            return this;
        }

        public final void setUseDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbInstanceReadReplicaRequest build() {
            return new CreateDbInstanceReadReplicaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDbInstanceReadReplicaRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder sourceDBInstanceIdentifier(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder availabilityZone(String var1);

        public Builder port(Integer var1);

        public Builder multiAZ(Boolean var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder iops(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder storageType(String var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder monitoringInterval(Integer var1);

        public Builder monitoringRoleArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder preSignedUrl(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder enablePerformanceInsights(Boolean var1);

        public Builder performanceInsightsKMSKeyId(String var1);

        public Builder performanceInsightsRetentionPeriod(Integer var1);

        public Builder enableCloudwatchLogsExports(Collection<String> var1);

        public Builder enableCloudwatchLogsExports(String ... var1);

        public Builder processorFeatures(Collection<ProcessorFeature> var1);

        public Builder processorFeatures(ProcessorFeature ... var1);

        public Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... var1);

        public Builder useDefaultProcessorFeatures(Boolean var1);

        public Builder deletionProtection(Boolean var1);

        public Builder sourceRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

