/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.CopyDBParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CopyDBParameterGroupRequestMarshaller
implements Marshaller<Request<CopyDBParameterGroupRequest>, CopyDBParameterGroupRequest> {
    public Request<CopyDBParameterGroupRequest> marshall(CopyDBParameterGroupRequest copyDBParameterGroupRequest) {
        List<Tag> tagsList;
        if (copyDBParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyDBParameterGroupRequest, "RDSClient");
        request.addParameter("Action", "CopyDBParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDBParameterGroupRequest.sourceDBParameterGroupIdentifier() != null) {
            request.addParameter("SourceDBParameterGroupIdentifier", StringUtils.fromString((String)copyDBParameterGroupRequest.sourceDBParameterGroupIdentifier()));
        }
        if (copyDBParameterGroupRequest.targetDBParameterGroupIdentifier() != null) {
            request.addParameter("TargetDBParameterGroupIdentifier", StringUtils.fromString((String)copyDBParameterGroupRequest.targetDBParameterGroupIdentifier()));
        }
        if (copyDBParameterGroupRequest.targetDBParameterGroupDescription() != null) {
            request.addParameter("TargetDBParameterGroupDescription", StringUtils.fromString((String)copyDBParameterGroupRequest.targetDBParameterGroupDescription()));
        }
        if ((tagsList = copyDBParameterGroupRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

