/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpgradeTarget
implements ToCopyableBuilder<Builder, UpgradeTarget> {
    private final String engine;
    private final String engineVersion;
    private final String description;
    private final Boolean autoUpgrade;
    private final Boolean isMajorVersionUpgrade;

    private UpgradeTarget(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.description = builder.description;
        this.autoUpgrade = builder.autoUpgrade;
        this.isMajorVersionUpgrade = builder.isMajorVersionUpgrade;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String description() {
        return this.description;
    }

    public Boolean autoUpgrade() {
        return this.autoUpgrade;
    }

    public Boolean isMajorVersionUpgrade() {
        return this.isMajorVersionUpgrade;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.autoUpgrade() == null ? 0 : this.autoUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.isMajorVersionUpgrade() == null ? 0 : this.isMajorVersionUpgrade().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeTarget)) {
            return false;
        }
        UpgradeTarget other = (UpgradeTarget)obj;
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.autoUpgrade() == null ^ this.autoUpgrade() == null) {
            return false;
        }
        if (other.autoUpgrade() != null && !other.autoUpgrade().equals(this.autoUpgrade())) {
            return false;
        }
        if (other.isMajorVersionUpgrade() == null ^ this.isMajorVersionUpgrade() == null) {
            return false;
        }
        return other.isMajorVersionUpgrade() == null || other.isMajorVersionUpgrade().equals(this.isMajorVersionUpgrade());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.autoUpgrade() != null) {
            sb.append("AutoUpgrade: ").append(this.autoUpgrade()).append(",");
        }
        if (this.isMajorVersionUpgrade() != null) {
            sb.append("IsMajorVersionUpgrade: ").append(this.isMajorVersionUpgrade()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String description;
        private Boolean autoUpgrade;
        private Boolean isMajorVersionUpgrade;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeTarget model) {
            this.setEngine(model.engine);
            this.setEngineVersion(model.engineVersion);
            this.setDescription(model.description);
            this.setAutoUpgrade(model.autoUpgrade);
            this.setIsMajorVersionUpgrade(model.isMajorVersionUpgrade);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getAutoUpgrade() {
            return this.autoUpgrade;
        }

        @Override
        public final Builder autoUpgrade(Boolean autoUpgrade) {
            this.autoUpgrade = autoUpgrade;
            return this;
        }

        public final void setAutoUpgrade(Boolean autoUpgrade) {
            this.autoUpgrade = autoUpgrade;
        }

        public final Boolean getIsMajorVersionUpgrade() {
            return this.isMajorVersionUpgrade;
        }

        @Override
        public final Builder isMajorVersionUpgrade(Boolean isMajorVersionUpgrade) {
            this.isMajorVersionUpgrade = isMajorVersionUpgrade;
            return this;
        }

        public final void setIsMajorVersionUpgrade(Boolean isMajorVersionUpgrade) {
            this.isMajorVersionUpgrade = isMajorVersionUpgrade;
        }

        public UpgradeTarget build() {
            return new UpgradeTarget(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpgradeTarget> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder description(String var1);

        public Builder autoUpgrade(Boolean var1);

        public Builder isMajorVersionUpgrade(Boolean var1);
    }
}

