/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SourceRegion
implements ToCopyableBuilder<Builder, SourceRegion> {
    private final String regionName;
    private final String endpoint;
    private final String status;

    private SourceRegion(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.endpoint = builder.endpoint;
        this.status = builder.status;
    }

    public String regionName() {
        return this.regionName;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.regionName() == null ? 0 : this.regionName().hashCode());
        hashCode = 31 * hashCode + (this.endpoint() == null ? 0 : this.endpoint().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceRegion)) {
            return false;
        }
        SourceRegion other = (SourceRegion)obj;
        if (other.regionName() == null ^ this.regionName() == null) {
            return false;
        }
        if (other.regionName() != null && !other.regionName().equals(this.regionName())) {
            return false;
        }
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        if (other.endpoint() != null && !other.endpoint().equals(this.endpoint())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.regionName() != null) {
            sb.append("RegionName: ").append(this.regionName()).append(",");
        }
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String endpoint;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceRegion model) {
            this.setRegionName(model.regionName);
            this.setEndpoint(model.endpoint);
            this.setStatus(model.status);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public SourceRegion build() {
            return new SourceRegion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SourceRegion> {
        public Builder regionName(String var1);

        public Builder endpoint(String var1);

        public Builder status(String var1);
    }
}

