/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OptionVersion
implements ToCopyableBuilder<Builder, OptionVersion> {
    private final String version;
    private final Boolean isDefault;

    private OptionVersion(BuilderImpl builder) {
        this.version = builder.version;
        this.isDefault = builder.isDefault;
    }

    public String version() {
        return this.version;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.isDefault() == null ? 0 : this.isDefault().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionVersion)) {
            return false;
        }
        OptionVersion other = (OptionVersion)obj;
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.isDefault() == null ^ this.isDefault() == null) {
            return false;
        }
        return other.isDefault() == null || other.isDefault().equals(this.isDefault());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.isDefault() != null) {
            sb.append("IsDefault: ").append(this.isDefault()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String version;
        private Boolean isDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionVersion model) {
            this.setVersion(model.version);
            this.setIsDefault(model.isDefault);
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public OptionVersion build() {
            return new OptionVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OptionVersion> {
        public Builder version(String var1);

        public Builder isDefault(Boolean var1);
    }
}

