/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DownloadDBLogFilePortionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DownloadDBLogFilePortionRequest> {
    private final String dbInstanceIdentifier;
    private final String logFileName;
    private final String marker;
    private final Integer numberOfLines;

    private DownloadDBLogFilePortionRequest(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.logFileName = builder.logFileName;
        this.marker = builder.marker;
        this.numberOfLines = builder.numberOfLines;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String logFileName() {
        return this.logFileName;
    }

    public String marker() {
        return this.marker;
    }

    public Integer numberOfLines() {
        return this.numberOfLines;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbInstanceIdentifier() == null ? 0 : this.dbInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.logFileName() == null ? 0 : this.logFileName().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.numberOfLines() == null ? 0 : this.numberOfLines().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownloadDBLogFilePortionRequest)) {
            return false;
        }
        DownloadDBLogFilePortionRequest other = (DownloadDBLogFilePortionRequest)((Object)obj);
        if (other.dbInstanceIdentifier() == null ^ this.dbInstanceIdentifier() == null) {
            return false;
        }
        if (other.dbInstanceIdentifier() != null && !other.dbInstanceIdentifier().equals(this.dbInstanceIdentifier())) {
            return false;
        }
        if (other.logFileName() == null ^ this.logFileName() == null) {
            return false;
        }
        if (other.logFileName() != null && !other.logFileName().equals(this.logFileName())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.numberOfLines() == null ^ this.numberOfLines() == null) {
            return false;
        }
        return other.numberOfLines() == null || other.numberOfLines().equals(this.numberOfLines());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.logFileName() != null) {
            sb.append("LogFileName: ").append(this.logFileName()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.numberOfLines() != null) {
            sb.append("NumberOfLines: ").append(this.numberOfLines()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String logFileName;
        private String marker;
        private Integer numberOfLines;

        private BuilderImpl() {
        }

        private BuilderImpl(DownloadDBLogFilePortionRequest model) {
            this.setDBInstanceIdentifier(model.dbInstanceIdentifier);
            this.setLogFileName(model.logFileName);
            this.setMarker(model.marker);
            this.setNumberOfLines(model.numberOfLines);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getLogFileName() {
            return this.logFileName;
        }

        @Override
        public final Builder logFileName(String logFileName) {
            this.logFileName = logFileName;
            return this;
        }

        public final void setLogFileName(String logFileName) {
            this.logFileName = logFileName;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getNumberOfLines() {
            return this.numberOfLines;
        }

        @Override
        public final Builder numberOfLines(Integer numberOfLines) {
            this.numberOfLines = numberOfLines;
            return this;
        }

        public final void setNumberOfLines(Integer numberOfLines) {
            this.numberOfLines = numberOfLines;
        }

        public DownloadDBLogFilePortionRequest build() {
            return new DownloadDBLogFilePortionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DownloadDBLogFilePortionRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder logFileName(String var1);

        public Builder marker(String var1);

        public Builder numberOfLines(Integer var1);
    }
}

