/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.DBSnapshot;
import software.amazon.awssdk.services.rds.model.DBSnapshotListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBSnapshotsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDBSnapshotsResponse> {
    private final String marker;
    private final List<DBSnapshot> dbSnapshots;

    private DescribeDBSnapshotsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.dbSnapshots = builder.dbSnapshots;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBSnapshot> dbSnapshots() {
        return this.dbSnapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.dbSnapshots() == null ? 0 : this.dbSnapshots().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBSnapshotsResponse)) {
            return false;
        }
        DescribeDBSnapshotsResponse other = (DescribeDBSnapshotsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.dbSnapshots() == null ^ this.dbSnapshots() == null) {
            return false;
        }
        return other.dbSnapshots() == null || other.dbSnapshots().equals(this.dbSnapshots());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.dbSnapshots() != null) {
            sb.append("DBSnapshots: ").append(this.dbSnapshots()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<DBSnapshot> dbSnapshots;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBSnapshotsResponse model) {
            this.setMarker(model.marker);
            this.setDBSnapshots(model.dbSnapshots);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBSnapshot> getDBSnapshots() {
            return this.dbSnapshots;
        }

        @Override
        public final Builder dbSnapshots(Collection<DBSnapshot> dbSnapshots) {
            this.dbSnapshots = DBSnapshotListCopier.copy(dbSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSnapshots(DBSnapshot ... dbSnapshots) {
            this.dbSnapshots(Arrays.asList(dbSnapshots));
            return this;
        }

        public final void setDBSnapshots(Collection<DBSnapshot> dbSnapshots) {
            this.dbSnapshots = DBSnapshotListCopier.copy(dbSnapshots);
        }

        @SafeVarargs
        public final void setDBSnapshots(DBSnapshot ... dbSnapshots) {
            this.dbSnapshots(Arrays.asList(dbSnapshots));
        }

        public DescribeDBSnapshotsResponse build() {
            return new DescribeDBSnapshotsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBSnapshotsResponse> {
        public Builder marker(String var1);

        public Builder dbSnapshots(Collection<DBSnapshot> var1);

        public Builder dbSnapshots(DBSnapshot ... var1);
    }
}

