/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.PrincipalArnOrIdListCopier;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.services.ram.model.ResourceOwner;
import software.amazon.awssdk.services.ram.model.ResourceShareArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPrincipalsRequest
extends RamRequest
implements ToCopyableBuilder<Builder, ListPrincipalsRequest> {
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPrincipalsRequest.getter(ListPrincipalsRequest::resourceOwnerAsString)).setter(ListPrincipalsRequest.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwner").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPrincipalsRequest.getter(ListPrincipalsRequest::resourceArn)).setter(ListPrincipalsRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<List<String>> PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListPrincipalsRequest.getter(ListPrincipalsRequest::principals)).setter(ListPrincipalsRequest.setter(Builder::principals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPrincipalsRequest.getter(ListPrincipalsRequest::resourceType)).setter(ListPrincipalsRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<String>> RESOURCE_SHARE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListPrincipalsRequest.getter(ListPrincipalsRequest::resourceShareArns)).setter(ListPrincipalsRequest.setter(Builder::resourceShareArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPrincipalsRequest.getter(ListPrincipalsRequest::nextToken)).setter(ListPrincipalsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListPrincipalsRequest.getter(ListPrincipalsRequest::maxResults)).setter(ListPrincipalsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_OWNER_FIELD, RESOURCE_ARN_FIELD, PRINCIPALS_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_SHARE_ARNS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String resourceOwner;
    private final String resourceArn;
    private final List<String> principals;
    private final String resourceType;
    private final List<String> resourceShareArns;
    private final String nextToken;
    private final Integer maxResults;

    private ListPrincipalsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceOwner = builder.resourceOwner;
        this.resourceArn = builder.resourceArn;
        this.principals = builder.principals;
        this.resourceType = builder.resourceType;
        this.resourceShareArns = builder.resourceShareArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(this.resourceOwner);
    }

    public String resourceOwnerAsString() {
        return this.resourceOwner;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public List<String> principals() {
        return this.principals;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public List<String> resourceShareArns() {
        return this.resourceShareArns;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.principals());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalsRequest)) {
            return false;
        }
        ListPrincipalsRequest other = (ListPrincipalsRequest)((Object)obj);
        return Objects.equals(this.resourceOwnerAsString(), other.resourceOwnerAsString()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.principals(), other.principals()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceShareArns(), other.resourceShareArns()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListPrincipalsRequest").add("ResourceOwner", (Object)this.resourceOwnerAsString()).add("ResourceArn", (Object)this.resourceArn()).add("Principals", this.principals()).add("ResourceType", (Object)this.resourceType()).add("ResourceShareArns", this.resourceShareArns()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAsString()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "resourceShareArns": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPrincipalsRequest, T> g) {
        return obj -> g.apply((ListPrincipalsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private String resourceOwner;
        private String resourceArn;
        private List<String> principals = DefaultSdkAutoConstructList.getInstance();
        private String resourceType;
        private List<String> resourceShareArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrincipalsRequest model) {
            super(model);
            this.resourceOwner(model.resourceOwner);
            this.resourceArn(model.resourceArn);
            this.principals(model.principals);
            this.resourceType(model.resourceType);
            this.resourceShareArns(model.resourceShareArns);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getResourceOwnerAsString() {
            return this.resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner == null ? null : resourceOwner.toString());
            return this;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<String> getPrincipals() {
            return this.principals;
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalArnOrIdListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalArnOrIdListCopier.copy(principals);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getResourceShareArns() {
            return this.resourceShareArns;
        }

        @Override
        public final Builder resourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareArns(String ... resourceShareArns) {
            this.resourceShareArns(Arrays.asList(resourceShareArns));
            return this;
        }

        public final void setResourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPrincipalsRequest build() {
            return new ListPrincipalsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPrincipalsRequest> {
        public Builder resourceOwner(String var1);

        public Builder resourceOwner(ResourceOwner var1);

        public Builder resourceArn(String var1);

        public Builder principals(Collection<String> var1);

        public Builder principals(String ... var1);

        public Builder resourceType(String var1);

        public Builder resourceShareArns(Collection<String> var1);

        public Builder resourceShareArns(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

