/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus;
import software.amazon.awssdk.services.ram.model.ResourceShareAssociationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceShareAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceShareAssociation> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceShareAssociation.getter(ResourceShareAssociation::resourceShareArn)).setter(ResourceShareAssociation.setter(Builder::resourceShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()}).build();
    private static final SdkField<String> ASSOCIATED_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceShareAssociation.getter(ResourceShareAssociation::associatedEntity)).setter(ResourceShareAssociation.setter(Builder::associatedEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedEntity").build()}).build();
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceShareAssociation.getter(ResourceShareAssociation::associationTypeAsString)).setter(ResourceShareAssociation.setter(Builder::associationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceShareAssociation.getter(ResourceShareAssociation::statusAsString)).setter(ResourceShareAssociation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceShareAssociation.getter(ResourceShareAssociation::statusMessage)).setter(ResourceShareAssociation.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ResourceShareAssociation.getter(ResourceShareAssociation::creationTime)).setter(ResourceShareAssociation.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ResourceShareAssociation.getter(ResourceShareAssociation::lastUpdatedTime)).setter(ResourceShareAssociation.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<Boolean> EXTERNAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ResourceShareAssociation.getter(ResourceShareAssociation::external)).setter(ResourceShareAssociation.setter(Builder::external)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("external").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD, ASSOCIATED_ENTITY_FIELD, ASSOCIATION_TYPE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, EXTERNAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceShareArn;
    private final String associatedEntity;
    private final String associationType;
    private final String status;
    private final String statusMessage;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final Boolean external;

    private ResourceShareAssociation(BuilderImpl builder) {
        this.resourceShareArn = builder.resourceShareArn;
        this.associatedEntity = builder.associatedEntity;
        this.associationType = builder.associationType;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.external = builder.external;
    }

    public String resourceShareArn() {
        return this.resourceShareArn;
    }

    public String associatedEntity() {
        return this.associatedEntity;
    }

    public ResourceShareAssociationType associationType() {
        return ResourceShareAssociationType.fromValue(this.associationType);
    }

    public String associationTypeAsString() {
        return this.associationType;
    }

    public ResourceShareAssociationStatus status() {
        return ResourceShareAssociationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Boolean external() {
        return this.external;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.external());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceShareAssociation)) {
            return false;
        }
        ResourceShareAssociation other = (ResourceShareAssociation)obj;
        return Objects.equals(this.resourceShareArn(), other.resourceShareArn()) && Objects.equals(this.associatedEntity(), other.associatedEntity()) && Objects.equals(this.associationTypeAsString(), other.associationTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.external(), other.external());
    }

    public String toString() {
        return ToString.builder((String)"ResourceShareAssociation").add("ResourceShareArn", (Object)this.resourceShareArn()).add("AssociatedEntity", (Object)this.associatedEntity()).add("AssociationType", (Object)this.associationTypeAsString()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("External", (Object)this.external()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArn()));
            }
            case "associatedEntity": {
                return Optional.ofNullable(clazz.cast(this.associatedEntity()));
            }
            case "associationType": {
                return Optional.ofNullable(clazz.cast(this.associationTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "external": {
                return Optional.ofNullable(clazz.cast(this.external()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceShareAssociation, T> g) {
        return obj -> g.apply((ResourceShareAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceShareArn;
        private String associatedEntity;
        private String associationType;
        private String status;
        private String statusMessage;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private Boolean external;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceShareAssociation model) {
            this.resourceShareArn(model.resourceShareArn);
            this.associatedEntity(model.associatedEntity);
            this.associationType(model.associationType);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.external(model.external);
        }

        public final String getResourceShareArn() {
            return this.resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        public final String getAssociatedEntity() {
            return this.associatedEntity;
        }

        @Override
        public final Builder associatedEntity(String associatedEntity) {
            this.associatedEntity = associatedEntity;
            return this;
        }

        public final void setAssociatedEntity(String associatedEntity) {
            this.associatedEntity = associatedEntity;
        }

        public final String getAssociationTypeAsString() {
            return this.associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(ResourceShareAssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceShareAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final Boolean getExternal() {
            return this.external;
        }

        @Override
        public final Builder external(Boolean external) {
            this.external = external;
            return this;
        }

        public final void setExternal(Boolean external) {
            this.external = external;
        }

        public ResourceShareAssociation build() {
            return new ResourceShareAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceShareAssociation> {
        public Builder resourceShareArn(String var1);

        public Builder associatedEntity(String var1);

        public Builder associationType(String var1);

        public Builder associationType(ResourceShareAssociationType var1);

        public Builder status(String var1);

        public Builder status(ResourceShareAssociationStatus var1);

        public Builder statusMessage(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder external(Boolean var1);
    }
}

