/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.services.ram.model.ResourceOwner;
import software.amazon.awssdk.services.ram.model.ResourceShareArnListCopier;
import software.amazon.awssdk.services.ram.model.ResourceShareStatus;
import software.amazon.awssdk.services.ram.model.TagFilter;
import software.amazon.awssdk.services.ram.model.TagFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceSharesRequest
extends RamRequest
implements ToCopyableBuilder<Builder, GetResourceSharesRequest> {
    private static final SdkField<List<String>> RESOURCE_SHARE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::resourceShareArns)).setter(GetResourceSharesRequest.setter(Builder::resourceShareArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_SHARE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::resourceShareStatusAsString)).setter(GetResourceSharesRequest.setter(Builder::resourceShareStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareStatus").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::resourceOwnerAsString)).setter(GetResourceSharesRequest.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwner").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::name)).setter(GetResourceSharesRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<TagFilter>> TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::tagFilters)).setter(GetResourceSharesRequest.setter(Builder::tagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::nextToken)).setter(GetResourceSharesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::maxResults)).setter(GetResourceSharesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARNS_FIELD, RESOURCE_SHARE_STATUS_FIELD, RESOURCE_OWNER_FIELD, NAME_FIELD, TAG_FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> resourceShareArns;
    private final String resourceShareStatus;
    private final String resourceOwner;
    private final String name;
    private final List<TagFilter> tagFilters;
    private final String nextToken;
    private final Integer maxResults;

    private GetResourceSharesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareArns = builder.resourceShareArns;
        this.resourceShareStatus = builder.resourceShareStatus;
        this.resourceOwner = builder.resourceOwner;
        this.name = builder.name;
        this.tagFilters = builder.tagFilters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<String> resourceShareArns() {
        return this.resourceShareArns;
    }

    public ResourceShareStatus resourceShareStatus() {
        return ResourceShareStatus.fromValue(this.resourceShareStatus);
    }

    public String resourceShareStatusAsString() {
        return this.resourceShareStatus;
    }

    public ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(this.resourceOwner);
    }

    public String resourceOwnerAsString() {
        return this.resourceOwner;
    }

    public String name() {
        return this.name;
    }

    public List<TagFilter> tagFilters() {
        return this.tagFilters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceSharesRequest)) {
            return false;
        }
        GetResourceSharesRequest other = (GetResourceSharesRequest)((Object)obj);
        return Objects.equals(this.resourceShareArns(), other.resourceShareArns()) && Objects.equals(this.resourceShareStatusAsString(), other.resourceShareStatusAsString()) && Objects.equals(this.resourceOwnerAsString(), other.resourceOwnerAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.tagFilters(), other.tagFilters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"GetResourceSharesRequest").add("ResourceShareArns", this.resourceShareArns()).add("ResourceShareStatus", (Object)this.resourceShareStatusAsString()).add("ResourceOwner", (Object)this.resourceOwnerAsString()).add("Name", (Object)this.name()).add("TagFilters", this.tagFilters()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareArns": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArns()));
            }
            case "resourceShareStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceShareStatusAsString()));
            }
            case "resourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tagFilters": {
                return Optional.ofNullable(clazz.cast(this.tagFilters()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceSharesRequest, T> g) {
        return obj -> g.apply((GetResourceSharesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private List<String> resourceShareArns = DefaultSdkAutoConstructList.getInstance();
        private String resourceShareStatus;
        private String resourceOwner;
        private String name;
        private List<TagFilter> tagFilters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceSharesRequest model) {
            super(model);
            this.resourceShareArns(model.resourceShareArns);
            this.resourceShareStatus(model.resourceShareStatus);
            this.resourceOwner(model.resourceOwner);
            this.name(model.name);
            this.tagFilters(model.tagFilters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getResourceShareArns() {
            return this.resourceShareArns;
        }

        @Override
        public final Builder resourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareArns(String ... resourceShareArns) {
            this.resourceShareArns(Arrays.asList(resourceShareArns));
            return this;
        }

        public final void setResourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
        }

        public final String getResourceShareStatusAsString() {
            return this.resourceShareStatus;
        }

        @Override
        public final Builder resourceShareStatus(String resourceShareStatus) {
            this.resourceShareStatus = resourceShareStatus;
            return this;
        }

        @Override
        public final Builder resourceShareStatus(ResourceShareStatus resourceShareStatus) {
            this.resourceShareStatus(resourceShareStatus.toString());
            return this;
        }

        public final void setResourceShareStatus(String resourceShareStatus) {
            this.resourceShareStatus = resourceShareStatus;
        }

        public final String getResourceOwnerAsString() {
            return this.resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner.toString());
            return this;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<TagFilter.Builder> getTagFilters() {
            return this.tagFilters != null ? (Collection)this.tagFilters.stream().map(TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagFilters(Collection<TagFilter> tagFilters) {
            this.tagFilters = TagFiltersCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(TagFilter ... tagFilters) {
            this.tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(Consumer<TagFilter.Builder> ... tagFilters) {
            this.tagFilters(Stream.of(tagFilters).map(c -> (TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagFilters(Collection<TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = TagFiltersCopier.copyFromBuilder(tagFilters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceSharesRequest build() {
            return new GetResourceSharesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceSharesRequest> {
        public Builder resourceShareArns(Collection<String> var1);

        public Builder resourceShareArns(String ... var1);

        public Builder resourceShareStatus(String var1);

        public Builder resourceShareStatus(ResourceShareStatus var1);

        public Builder resourceOwner(String var1);

        public Builder resourceOwner(ResourceOwner var1);

        public Builder name(String var1);

        public Builder tagFilters(Collection<TagFilter> var1);

        public Builder tagFilters(TagFilter ... var1);

        public Builder tagFilters(Consumer<TagFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

