/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PermissionFeatureSet {
    CREATED_FROM_POLICY("CREATED_FROM_POLICY"),
    PROMOTING_TO_STANDARD("PROMOTING_TO_STANDARD"),
    STANDARD("STANDARD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PermissionFeatureSet> VALUE_MAP;
    private final String value;

    private PermissionFeatureSet(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PermissionFeatureSet fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PermissionFeatureSet> knownValues() {
        EnumSet<PermissionFeatureSet> knownValues = EnumSet.allOf(PermissionFeatureSet.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PermissionFeatureSet.class, PermissionFeatureSet::toString);
    }
}

