/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamAsyncClient;
import software.amazon.awssdk.services.ram.internal.UserAgentUtils;
import software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkRequest;
import software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkResponse;

public class ListReplacePermissionAssociationsWorkPublisher
implements SdkPublisher<ListReplacePermissionAssociationsWorkResponse> {
    private final RamAsyncClient client;
    private final ListReplacePermissionAssociationsWorkRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReplacePermissionAssociationsWorkPublisher(RamAsyncClient client, ListReplacePermissionAssociationsWorkRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReplacePermissionAssociationsWorkPublisher(RamAsyncClient client, ListReplacePermissionAssociationsWorkRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReplacePermissionAssociationsWorkResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReplacePermissionAssociationsWorkResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListReplacePermissionAssociationsWorkResponseFetcher
    implements AsyncPageFetcher<ListReplacePermissionAssociationsWorkResponse> {
        private ListReplacePermissionAssociationsWorkResponseFetcher() {
        }

        public boolean hasNextPage(ListReplacePermissionAssociationsWorkResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReplacePermissionAssociationsWorkResponse> nextPage(ListReplacePermissionAssociationsWorkResponse previousPage) {
            if (previousPage == null) {
                return ListReplacePermissionAssociationsWorkPublisher.this.client.listReplacePermissionAssociationsWork(ListReplacePermissionAssociationsWorkPublisher.this.firstRequest);
            }
            return ListReplacePermissionAssociationsWorkPublisher.this.client.listReplacePermissionAssociationsWork((ListReplacePermissionAssociationsWorkRequest)((Object)ListReplacePermissionAssociationsWorkPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

