/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplacePermissionAssociationsRequest
extends RamRequest
implements ToCopyableBuilder<Builder, ReplacePermissionAssociationsRequest> {
    private static final SdkField<String> FROM_PERMISSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fromPermissionArn").getter(ReplacePermissionAssociationsRequest.getter(ReplacePermissionAssociationsRequest::fromPermissionArn)).setter(ReplacePermissionAssociationsRequest.setter(Builder::fromPermissionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromPermissionArn").build()}).build();
    private static final SdkField<Integer> FROM_PERMISSION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("fromPermissionVersion").getter(ReplacePermissionAssociationsRequest.getter(ReplacePermissionAssociationsRequest::fromPermissionVersion)).setter(ReplacePermissionAssociationsRequest.setter(Builder::fromPermissionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromPermissionVersion").build()}).build();
    private static final SdkField<String> TO_PERMISSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("toPermissionArn").getter(ReplacePermissionAssociationsRequest.getter(ReplacePermissionAssociationsRequest::toPermissionArn)).setter(ReplacePermissionAssociationsRequest.setter(Builder::toPermissionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toPermissionArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(ReplacePermissionAssociationsRequest.getter(ReplacePermissionAssociationsRequest::clientToken)).setter(ReplacePermissionAssociationsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PERMISSION_ARN_FIELD, FROM_PERMISSION_VERSION_FIELD, TO_PERMISSION_ARN_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplacePermissionAssociationsRequest.memberNameToFieldInitializer();
    private final String fromPermissionArn;
    private final Integer fromPermissionVersion;
    private final String toPermissionArn;
    private final String clientToken;

    private ReplacePermissionAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.fromPermissionArn = builder.fromPermissionArn;
        this.fromPermissionVersion = builder.fromPermissionVersion;
        this.toPermissionArn = builder.toPermissionArn;
        this.clientToken = builder.clientToken;
    }

    public final String fromPermissionArn() {
        return this.fromPermissionArn;
    }

    public final Integer fromPermissionVersion() {
        return this.fromPermissionVersion;
    }

    public final String toPermissionArn() {
        return this.toPermissionArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPermissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPermissionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPermissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplacePermissionAssociationsRequest)) {
            return false;
        }
        ReplacePermissionAssociationsRequest other = (ReplacePermissionAssociationsRequest)((Object)obj);
        return Objects.equals(this.fromPermissionArn(), other.fromPermissionArn()) && Objects.equals(this.fromPermissionVersion(), other.fromPermissionVersion()) && Objects.equals(this.toPermissionArn(), other.toPermissionArn()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"ReplacePermissionAssociationsRequest").add("FromPermissionArn", (Object)this.fromPermissionArn()).add("FromPermissionVersion", (Object)this.fromPermissionVersion()).add("ToPermissionArn", (Object)this.toPermissionArn()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fromPermissionArn": {
                return Optional.ofNullable(clazz.cast(this.fromPermissionArn()));
            }
            case "fromPermissionVersion": {
                return Optional.ofNullable(clazz.cast(this.fromPermissionVersion()));
            }
            case "toPermissionArn": {
                return Optional.ofNullable(clazz.cast(this.toPermissionArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fromPermissionArn", FROM_PERMISSION_ARN_FIELD);
        map.put("fromPermissionVersion", FROM_PERMISSION_VERSION_FIELD);
        map.put("toPermissionArn", TO_PERMISSION_ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplacePermissionAssociationsRequest, T> g) {
        return obj -> g.apply((ReplacePermissionAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private String fromPermissionArn;
        private Integer fromPermissionVersion;
        private String toPermissionArn;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplacePermissionAssociationsRequest model) {
            super(model);
            this.fromPermissionArn(model.fromPermissionArn);
            this.fromPermissionVersion(model.fromPermissionVersion);
            this.toPermissionArn(model.toPermissionArn);
            this.clientToken(model.clientToken);
        }

        public final String getFromPermissionArn() {
            return this.fromPermissionArn;
        }

        public final void setFromPermissionArn(String fromPermissionArn) {
            this.fromPermissionArn = fromPermissionArn;
        }

        @Override
        public final Builder fromPermissionArn(String fromPermissionArn) {
            this.fromPermissionArn = fromPermissionArn;
            return this;
        }

        public final Integer getFromPermissionVersion() {
            return this.fromPermissionVersion;
        }

        public final void setFromPermissionVersion(Integer fromPermissionVersion) {
            this.fromPermissionVersion = fromPermissionVersion;
        }

        @Override
        public final Builder fromPermissionVersion(Integer fromPermissionVersion) {
            this.fromPermissionVersion = fromPermissionVersion;
            return this;
        }

        public final String getToPermissionArn() {
            return this.toPermissionArn;
        }

        public final void setToPermissionArn(String toPermissionArn) {
            this.toPermissionArn = toPermissionArn;
        }

        @Override
        public final Builder toPermissionArn(String toPermissionArn) {
            this.toPermissionArn = toPermissionArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplacePermissionAssociationsRequest build() {
            return new ReplacePermissionAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReplacePermissionAssociationsRequest> {
        public Builder fromPermissionArn(String var1);

        public Builder fromPermissionVersion(Integer var1);

        public Builder toPermissionArn(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

