/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitation;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceShareInvitationsResponse
extends RamResponse
implements ToCopyableBuilder<Builder, GetResourceShareInvitationsResponse> {
    private static final SdkField<List<ResourceShareInvitation>> RESOURCE_SHARE_INVITATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceShareInvitations").getter(GetResourceShareInvitationsResponse.getter(GetResourceShareInvitationsResponse::resourceShareInvitations)).setter(GetResourceShareInvitationsResponse.setter(Builder::resourceShareInvitations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareInvitations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceShareInvitation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetResourceShareInvitationsResponse.getter(GetResourceShareInvitationsResponse::nextToken)).setter(GetResourceShareInvitationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_INVITATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourceShareInvitationsResponse.memberNameToFieldInitializer();
    private final List<ResourceShareInvitation> resourceShareInvitations;
    private final String nextToken;

    private GetResourceShareInvitationsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShareInvitations = builder.resourceShareInvitations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceShareInvitations() {
        return this.resourceShareInvitations != null && !(this.resourceShareInvitations instanceof SdkAutoConstructList);
    }

    public final List<ResourceShareInvitation> resourceShareInvitations() {
        return this.resourceShareInvitations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceShareInvitations() ? this.resourceShareInvitations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceShareInvitationsResponse)) {
            return false;
        }
        GetResourceShareInvitationsResponse other = (GetResourceShareInvitationsResponse)((Object)obj);
        return this.hasResourceShareInvitations() == other.hasResourceShareInvitations() && Objects.equals(this.resourceShareInvitations(), other.resourceShareInvitations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceShareInvitationsResponse").add("ResourceShareInvitations", this.hasResourceShareInvitations() ? this.resourceShareInvitations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareInvitations": {
                return Optional.ofNullable(clazz.cast(this.resourceShareInvitations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceShareInvitations", RESOURCE_SHARE_INVITATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceShareInvitationsResponse, T> g) {
        return obj -> g.apply((GetResourceShareInvitationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private List<ResourceShareInvitation> resourceShareInvitations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceShareInvitationsResponse model) {
            super(model);
            this.resourceShareInvitations(model.resourceShareInvitations);
            this.nextToken(model.nextToken);
        }

        public final List<ResourceShareInvitation.Builder> getResourceShareInvitations() {
            List<ResourceShareInvitation.Builder> result = ResourceShareInvitationListCopier.copyToBuilder(this.resourceShareInvitations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceShareInvitations(Collection<ResourceShareInvitation.BuilderImpl> resourceShareInvitations) {
            this.resourceShareInvitations = ResourceShareInvitationListCopier.copyFromBuilder(resourceShareInvitations);
        }

        @Override
        public final Builder resourceShareInvitations(Collection<ResourceShareInvitation> resourceShareInvitations) {
            this.resourceShareInvitations = ResourceShareInvitationListCopier.copy(resourceShareInvitations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareInvitations(ResourceShareInvitation ... resourceShareInvitations) {
            this.resourceShareInvitations(Arrays.asList(resourceShareInvitations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareInvitations(Consumer<ResourceShareInvitation.Builder> ... resourceShareInvitations) {
            this.resourceShareInvitations(Stream.of(resourceShareInvitations).map(c -> (ResourceShareInvitation)((ResourceShareInvitation.Builder)ResourceShareInvitation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetResourceShareInvitationsResponse build() {
            return new GetResourceShareInvitationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceShareInvitationsResponse> {
        public Builder resourceShareInvitations(Collection<ResourceShareInvitation> var1);

        public Builder resourceShareInvitations(ResourceShareInvitation ... var1);

        public Builder resourceShareInvitations(Consumer<ResourceShareInvitation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

