/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateResourceSharePermissionRequest
extends RamRequest
implements ToCopyableBuilder<Builder, DisassociateResourceSharePermissionRequest> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareArn").getter(DisassociateResourceSharePermissionRequest.getter(DisassociateResourceSharePermissionRequest::resourceShareArn)).setter(DisassociateResourceSharePermissionRequest.setter(Builder::resourceShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()}).build();
    private static final SdkField<String> PERMISSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionArn").getter(DisassociateResourceSharePermissionRequest.getter(DisassociateResourceSharePermissionRequest::permissionArn)).setter(DisassociateResourceSharePermissionRequest.setter(Builder::permissionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DisassociateResourceSharePermissionRequest.getter(DisassociateResourceSharePermissionRequest::clientToken)).setter(DisassociateResourceSharePermissionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD, PERMISSION_ARN_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceShareArn", RESOURCE_SHARE_ARN_FIELD);
            this.put("permissionArn", PERMISSION_ARN_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String resourceShareArn;
    private final String permissionArn;
    private final String clientToken;

    private DisassociateResourceSharePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareArn = builder.resourceShareArn;
        this.permissionArn = builder.permissionArn;
        this.clientToken = builder.clientToken;
    }

    public final String resourceShareArn() {
        return this.resourceShareArn;
    }

    public final String permissionArn() {
        return this.permissionArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateResourceSharePermissionRequest)) {
            return false;
        }
        DisassociateResourceSharePermissionRequest other = (DisassociateResourceSharePermissionRequest)((Object)obj);
        return Objects.equals(this.resourceShareArn(), other.resourceShareArn()) && Objects.equals(this.permissionArn(), other.permissionArn()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateResourceSharePermissionRequest").add("ResourceShareArn", (Object)this.resourceShareArn()).add("PermissionArn", (Object)this.permissionArn()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArn()));
            }
            case "permissionArn": {
                return Optional.ofNullable(clazz.cast(this.permissionArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateResourceSharePermissionRequest, T> g) {
        return obj -> g.apply((DisassociateResourceSharePermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private String resourceShareArn;
        private String permissionArn;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateResourceSharePermissionRequest model) {
            super(model);
            this.resourceShareArn(model.resourceShareArn);
            this.permissionArn(model.permissionArn);
            this.clientToken(model.clientToken);
        }

        public final String getResourceShareArn() {
            return this.resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final String getPermissionArn() {
            return this.permissionArn;
        }

        public final void setPermissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
        }

        @Override
        public final Builder permissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateResourceSharePermissionRequest build() {
            return new DisassociateResourceSharePermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateResourceSharePermissionRequest> {
        public Builder resourceShareArn(String var1);

        public Builder permissionArn(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

