/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptResourceShareInvitationResponse
extends RamResponse
implements ToCopyableBuilder<Builder, AcceptResourceShareInvitationResponse> {
    private static final SdkField<ResourceShareInvitation> RESOURCE_SHARE_INVITATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceShareInvitation").getter(AcceptResourceShareInvitationResponse.getter(AcceptResourceShareInvitationResponse::resourceShareInvitation)).setter(AcceptResourceShareInvitationResponse.setter(Builder::resourceShareInvitation)).constructor(ResourceShareInvitation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareInvitation").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AcceptResourceShareInvitationResponse.getter(AcceptResourceShareInvitationResponse::clientToken)).setter(AcceptResourceShareInvitationResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_INVITATION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceShareInvitation", RESOURCE_SHARE_INVITATION_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final ResourceShareInvitation resourceShareInvitation;
    private final String clientToken;

    private AcceptResourceShareInvitationResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShareInvitation = builder.resourceShareInvitation;
        this.clientToken = builder.clientToken;
    }

    public final ResourceShareInvitation resourceShareInvitation() {
        return this.resourceShareInvitation;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareInvitation());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptResourceShareInvitationResponse)) {
            return false;
        }
        AcceptResourceShareInvitationResponse other = (AcceptResourceShareInvitationResponse)((Object)obj);
        return Objects.equals(this.resourceShareInvitation(), other.resourceShareInvitation()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptResourceShareInvitationResponse").add("ResourceShareInvitation", (Object)this.resourceShareInvitation()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareInvitation": {
                return Optional.ofNullable(clazz.cast(this.resourceShareInvitation()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AcceptResourceShareInvitationResponse, T> g) {
        return obj -> g.apply((AcceptResourceShareInvitationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private ResourceShareInvitation resourceShareInvitation;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptResourceShareInvitationResponse model) {
            super(model);
            this.resourceShareInvitation(model.resourceShareInvitation);
            this.clientToken(model.clientToken);
        }

        public final ResourceShareInvitation.Builder getResourceShareInvitation() {
            return this.resourceShareInvitation != null ? this.resourceShareInvitation.toBuilder() : null;
        }

        public final void setResourceShareInvitation(ResourceShareInvitation.BuilderImpl resourceShareInvitation) {
            this.resourceShareInvitation = resourceShareInvitation != null ? resourceShareInvitation.build() : null;
        }

        @Override
        public final Builder resourceShareInvitation(ResourceShareInvitation resourceShareInvitation) {
            this.resourceShareInvitation = resourceShareInvitation;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public AcceptResourceShareInvitationResponse build() {
            return new AcceptResourceShareInvitationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptResourceShareInvitationResponse> {
        public Builder resourceShareInvitation(ResourceShareInvitation var1);

        default public Builder resourceShareInvitation(Consumer<ResourceShareInvitation.Builder> resourceShareInvitation) {
            return this.resourceShareInvitation((ResourceShareInvitation)((ResourceShareInvitation.Builder)ResourceShareInvitation.builder().applyMutation(resourceShareInvitation)).build());
        }

        public Builder clientToken(String var1);
    }
}

