/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.PermissionFeatureSet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatedPermission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociatedPermission> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(AssociatedPermission.getter(AssociatedPermission::arn)).setter(AssociatedPermission.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> PERMISSION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionVersion").getter(AssociatedPermission.getter(AssociatedPermission::permissionVersion)).setter(AssociatedPermission.setter(Builder::permissionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionVersion").build()}).build();
    private static final SdkField<Boolean> DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("defaultVersion").getter(AssociatedPermission.getter(AssociatedPermission::defaultVersion)).setter(AssociatedPermission.setter(Builder::defaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersion").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(AssociatedPermission.getter(AssociatedPermission::resourceType)).setter(AssociatedPermission.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AssociatedPermission.getter(AssociatedPermission::status)).setter(AssociatedPermission.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FEATURE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("featureSet").getter(AssociatedPermission.getter(AssociatedPermission::featureSetAsString)).setter(AssociatedPermission.setter(Builder::featureSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureSet").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(AssociatedPermission.getter(AssociatedPermission::lastUpdatedTime)).setter(AssociatedPermission.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareArn").getter(AssociatedPermission.getter(AssociatedPermission::resourceShareArn)).setter(AssociatedPermission.setter(Builder::resourceShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PERMISSION_VERSION_FIELD, DEFAULT_VERSION_FIELD, RESOURCE_TYPE_FIELD, STATUS_FIELD, FEATURE_SET_FIELD, LAST_UPDATED_TIME_FIELD, RESOURCE_SHARE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("permissionVersion", PERMISSION_VERSION_FIELD);
            this.put("defaultVersion", DEFAULT_VERSION_FIELD);
            this.put("resourceType", RESOURCE_TYPE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("featureSet", FEATURE_SET_FIELD);
            this.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("resourceShareArn", RESOURCE_SHARE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String permissionVersion;
    private final Boolean defaultVersion;
    private final String resourceType;
    private final String status;
    private final String featureSet;
    private final Instant lastUpdatedTime;
    private final String resourceShareArn;

    private AssociatedPermission(BuilderImpl builder) {
        this.arn = builder.arn;
        this.permissionVersion = builder.permissionVersion;
        this.defaultVersion = builder.defaultVersion;
        this.resourceType = builder.resourceType;
        this.status = builder.status;
        this.featureSet = builder.featureSet;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.resourceShareArn = builder.resourceShareArn;
    }

    public final String arn() {
        return this.arn;
    }

    public final String permissionVersion() {
        return this.permissionVersion;
    }

    public final Boolean defaultVersion() {
        return this.defaultVersion;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String status() {
        return this.status;
    }

    public final PermissionFeatureSet featureSet() {
        return PermissionFeatureSet.fromValue(this.featureSet);
    }

    public final String featureSetAsString() {
        return this.featureSet;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String resourceShareArn() {
        return this.resourceShareArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureSetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedPermission)) {
            return false;
        }
        AssociatedPermission other = (AssociatedPermission)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.permissionVersion(), other.permissionVersion()) && Objects.equals(this.defaultVersion(), other.defaultVersion()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.featureSetAsString(), other.featureSetAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.resourceShareArn(), other.resourceShareArn());
    }

    public final String toString() {
        return ToString.builder((String)"AssociatedPermission").add("Arn", (Object)this.arn()).add("PermissionVersion", (Object)this.permissionVersion()).add("DefaultVersion", (Object)this.defaultVersion()).add("ResourceType", (Object)this.resourceType()).add("Status", (Object)this.status()).add("FeatureSet", (Object)this.featureSetAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("ResourceShareArn", (Object)this.resourceShareArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "permissionVersion": {
                return Optional.ofNullable(clazz.cast(this.permissionVersion()));
            }
            case "defaultVersion": {
                return Optional.ofNullable(clazz.cast(this.defaultVersion()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "featureSet": {
                return Optional.ofNullable(clazz.cast(this.featureSetAsString()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "resourceShareArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociatedPermission, T> g) {
        return obj -> g.apply((AssociatedPermission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String permissionVersion;
        private Boolean defaultVersion;
        private String resourceType;
        private String status;
        private String featureSet;
        private Instant lastUpdatedTime;
        private String resourceShareArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedPermission model) {
            this.arn(model.arn);
            this.permissionVersion(model.permissionVersion);
            this.defaultVersion(model.defaultVersion);
            this.resourceType(model.resourceType);
            this.status(model.status);
            this.featureSet(model.featureSet);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.resourceShareArn(model.resourceShareArn);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPermissionVersion() {
            return this.permissionVersion;
        }

        public final void setPermissionVersion(String permissionVersion) {
            this.permissionVersion = permissionVersion;
        }

        @Override
        public final Builder permissionVersion(String permissionVersion) {
            this.permissionVersion = permissionVersion;
            return this;
        }

        public final Boolean getDefaultVersion() {
            return this.defaultVersion;
        }

        public final void setDefaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        @Override
        public final Builder defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getFeatureSet() {
            return this.featureSet;
        }

        public final void setFeatureSet(String featureSet) {
            this.featureSet = featureSet;
        }

        @Override
        public final Builder featureSet(String featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public final Builder featureSet(PermissionFeatureSet featureSet) {
            this.featureSet(featureSet == null ? null : featureSet.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getResourceShareArn() {
            return this.resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public AssociatedPermission build() {
            return new AssociatedPermission(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociatedPermission> {
        public Builder arn(String var1);

        public Builder permissionVersion(String var1);

        public Builder defaultVersion(Boolean var1);

        public Builder resourceType(String var1);

        public Builder status(String var1);

        public Builder featureSet(String var1);

        public Builder featureSet(PermissionFeatureSet var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder resourceShareArn(String var1);
    }
}

