/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamAsyncClient;
import software.amazon.awssdk.services.ram.internal.UserAgentUtils;
import software.amazon.awssdk.services.ram.model.GetResourceSharesRequest;
import software.amazon.awssdk.services.ram.model.GetResourceSharesResponse;

public class GetResourceSharesPublisher
implements SdkPublisher<GetResourceSharesResponse> {
    private final RamAsyncClient client;
    private final GetResourceSharesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourceSharesPublisher(RamAsyncClient client, GetResourceSharesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourceSharesPublisher(RamAsyncClient client, GetResourceSharesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourceSharesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourceSharesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetResourceSharesResponseFetcher
    implements AsyncPageFetcher<GetResourceSharesResponse> {
        private GetResourceSharesResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetResourceSharesResponse> nextPage(GetResourceSharesResponse previousPage) {
            if (previousPage == null) {
                return GetResourceSharesPublisher.this.client.getResourceShares(GetResourceSharesPublisher.this.firstRequest);
            }
            return GetResourceSharesPublisher.this.client.getResourceShares((GetResourceSharesRequest)((Object)GetResourceSharesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

