/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.services.ram.RamBaseClientBuilder;
import software.amazon.awssdk.services.ram.endpoints.RamEndpointProvider;
import software.amazon.awssdk.services.ram.endpoints.internal.RamRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.ram.endpoints.internal.RamResolveEndpointInterceptor;
import software.amazon.awssdk.services.ram.internal.RamServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ram.internal.SdkClientConfigurationUtil;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
abstract class DefaultRamBaseClientBuilder<B extends RamBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultRamBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "ram";
    }

    protected final String serviceName() {
        return "Ram";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkAdvancedClientOption.SIGNER, (Object)this.defaultSigner()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new RamResolveEndpointInterceptor());
        endpointInterceptors.add(new RamRequestSetEndpointInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/ram/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        SdkClientConfiguration.Builder builder = config.toBuilder();
        builder.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors);
        return builder.build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    protected final String signingName() {
        return "ram";
    }

    private RamEndpointProvider defaultEndpointProvider() {
        return RamEndpointProvider.defaultProvider();
    }

    protected SdkClientConfiguration setOverrides(SdkClientConfiguration configuration) {
        ClientOverrideConfiguration overrideConfiguration = this.overrideConfiguration();
        if (overrideConfiguration == null) {
            return configuration;
        }
        return SdkClientConfigurationUtil.copyOverridesToConfiguration(overrideConfiguration, configuration.toBuilder()).build();
    }

    protected SdkClientConfiguration invokePlugins(SdkClientConfiguration config) {
        List plugins = this.plugins();
        if (plugins.isEmpty()) {
            return config;
        }
        RamServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = RamServiceClientConfigurationBuilder.builder(config.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.overrideConfiguration(serviceConfigBuilder.overrideConfiguration());
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    protected static void validateClientOptions(SdkClientConfiguration c) {
        Validate.notNull((Object)c.option((ClientOption)SdkAdvancedClientOption.SIGNER), (String)"The 'overrideConfiguration.advancedOption[SIGNER]' must be configured in the client builder.", (Object[])new Object[0]);
    }
}

