/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a shareable resource type and the Amazon Web Services service to which resources of that type
 * belong.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceNameAndResourceType implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceNameAndResourceType.Builder, ServiceNameAndResourceType> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ServiceNameAndResourceType::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(ServiceNameAndResourceType::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> RESOURCE_REGION_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceRegionScope").getter(getter(ServiceNameAndResourceType::resourceRegionScopeAsString))
            .setter(setter(Builder::resourceRegionScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRegionScope").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            SERVICE_NAME_FIELD, RESOURCE_REGION_SCOPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String serviceName;

    private final String resourceRegionScope;

    private ServiceNameAndResourceType(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.serviceName = builder.serviceName;
        this.resourceRegionScope = builder.resourceRegionScope;
    }

    /**
     * <p>
     * The type of the resource. This takes the form of: <code>service-code</code>:<code>resource-code</code>, and is
     * case-insensitive. For example, an Amazon EC2 Subnet would be represented by the string <code>ec2:subnet</code>.
     * </p>
     * 
     * @return The type of the resource. This takes the form of: <code>service-code</code>:<code>resource-code</code>,
     *         and is case-insensitive. For example, an Amazon EC2 Subnet would be represented by the string
     *         <code>ec2:subnet</code>.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The name of the Amazon Web Services service to which resources of this type belong.
     * </p>
     * 
     * @return The name of the Amazon Web Services service to which resources of this type belong.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * Specifies the scope of visibility of resources of this type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>REGIONAL</b> – The resource can be accessed only by using requests that target the Amazon Web Services Region
     * in which the resource exists.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>GLOBAL</b> – The resource can be accessed from any Amazon Web Services Region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceRegionScope} will return {@link ResourceRegionScope#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceRegionScopeAsString}.
     * </p>
     * 
     * @return Specifies the scope of visibility of resources of this type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>REGIONAL</b> – The resource can be accessed only by using requests that target the Amazon Web Services
     *         Region in which the resource exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>GLOBAL</b> – The resource can be accessed from any Amazon Web Services Region.
     *         </p>
     *         </li>
     * @see ResourceRegionScope
     */
    public final ResourceRegionScope resourceRegionScope() {
        return ResourceRegionScope.fromValue(resourceRegionScope);
    }

    /**
     * <p>
     * Specifies the scope of visibility of resources of this type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>REGIONAL</b> – The resource can be accessed only by using requests that target the Amazon Web Services Region
     * in which the resource exists.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>GLOBAL</b> – The resource can be accessed from any Amazon Web Services Region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceRegionScope} will return {@link ResourceRegionScope#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceRegionScopeAsString}.
     * </p>
     * 
     * @return Specifies the scope of visibility of resources of this type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>REGIONAL</b> – The resource can be accessed only by using requests that target the Amazon Web Services
     *         Region in which the resource exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>GLOBAL</b> – The resource can be accessed from any Amazon Web Services Region.
     *         </p>
     *         </li>
     * @see ResourceRegionScope
     */
    public final String resourceRegionScopeAsString() {
        return resourceRegionScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRegionScopeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNameAndResourceType)) {
            return false;
        }
        ServiceNameAndResourceType other = (ServiceNameAndResourceType) obj;
        return Objects.equals(resourceType(), other.resourceType()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(resourceRegionScopeAsString(), other.resourceRegionScopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceNameAndResourceType").add("ResourceType", resourceType())
                .add("ServiceName", serviceName()).add("ResourceRegionScope", resourceRegionScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "resourceRegionScope":
            return Optional.ofNullable(clazz.cast(resourceRegionScopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceNameAndResourceType, T> g) {
        return obj -> g.apply((ServiceNameAndResourceType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceNameAndResourceType> {
        /**
         * <p>
         * The type of the resource. This takes the form of: <code>service-code</code>:<code>resource-code</code>, and
         * is case-insensitive. For example, an Amazon EC2 Subnet would be represented by the string
         * <code>ec2:subnet</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource. This takes the form of: <code>service-code</code>:<code>resource-code</code>
         *        , and is case-insensitive. For example, an Amazon EC2 Subnet would be represented by the string
         *        <code>ec2:subnet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The name of the Amazon Web Services service to which resources of this type belong.
         * </p>
         * 
         * @param serviceName
         *        The name of the Amazon Web Services service to which resources of this type belong.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * Specifies the scope of visibility of resources of this type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>REGIONAL</b> – The resource can be accessed only by using requests that target the Amazon Web Services
         * Region in which the resource exists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>GLOBAL</b> – The resource can be accessed from any Amazon Web Services Region.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceRegionScope
         *        Specifies the scope of visibility of resources of this type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>REGIONAL</b> – The resource can be accessed only by using requests that target the Amazon Web
         *        Services Region in which the resource exists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>GLOBAL</b> – The resource can be accessed from any Amazon Web Services Region.
         *        </p>
         *        </li>
         * @see ResourceRegionScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceRegionScope
         */
        Builder resourceRegionScope(String resourceRegionScope);

        /**
         * <p>
         * Specifies the scope of visibility of resources of this type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>REGIONAL</b> – The resource can be accessed only by using requests that target the Amazon Web Services
         * Region in which the resource exists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>GLOBAL</b> – The resource can be accessed from any Amazon Web Services Region.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceRegionScope
         *        Specifies the scope of visibility of resources of this type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>REGIONAL</b> – The resource can be accessed only by using requests that target the Amazon Web
         *        Services Region in which the resource exists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>GLOBAL</b> – The resource can be accessed from any Amazon Web Services Region.
         *        </p>
         *        </li>
         * @see ResourceRegionScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceRegionScope
         */
        Builder resourceRegionScope(ResourceRegionScope resourceRegionScope);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String serviceName;

        private String resourceRegionScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNameAndResourceType model) {
            resourceType(model.resourceType);
            serviceName(model.serviceName);
            resourceRegionScope(model.resourceRegionScope);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getResourceRegionScope() {
            return resourceRegionScope;
        }

        public final void setResourceRegionScope(String resourceRegionScope) {
            this.resourceRegionScope = resourceRegionScope;
        }

        @Override
        public final Builder resourceRegionScope(String resourceRegionScope) {
            this.resourceRegionScope = resourceRegionScope;
            return this;
        }

        @Override
        public final Builder resourceRegionScope(ResourceRegionScope resourceRegionScope) {
            this.resourceRegionScope(resourceRegionScope == null ? null : resourceRegionScope.toString());
            return this;
        }

        @Override
        public ServiceNameAndResourceType build() {
            return new ServiceNameAndResourceType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
