/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ram.DefaultRamAsyncClient;
import software.amazon.awssdk.services.ram.DefaultRamBaseClientBuilder;
import software.amazon.awssdk.services.ram.RamAsyncClient;
import software.amazon.awssdk.services.ram.RamAsyncClientBuilder;
import software.amazon.awssdk.services.ram.RamServiceClientConfiguration;
import software.amazon.awssdk.services.ram.endpoints.RamEndpointProvider;

@SdkInternalApi
final class DefaultRamAsyncClientBuilder
extends DefaultRamBaseClientBuilder<RamAsyncClientBuilder, RamAsyncClient>
implements RamAsyncClientBuilder {
    DefaultRamAsyncClientBuilder() {
    }

    @Override
    public DefaultRamAsyncClientBuilder endpointProvider(RamEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RamAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultRamAsyncClientBuilder.validateClientOptions(clientConfiguration);
        RamServiceClientConfiguration serviceClientConfiguration = RamServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultRamAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

