/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.services.ram.model.ResourceShareAssociation;
import software.amazon.awssdk.services.ram.model.ResourceShareAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceShareAssociationsResponse
extends RamResponse
implements ToCopyableBuilder<Builder, GetResourceShareAssociationsResponse> {
    private static final SdkField<List<ResourceShareAssociation>> RESOURCE_SHARE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceShareAssociations").getter(GetResourceShareAssociationsResponse.getter(GetResourceShareAssociationsResponse::resourceShareAssociations)).setter(GetResourceShareAssociationsResponse.setter(Builder::resourceShareAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceShareAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetResourceShareAssociationsResponse.getter(GetResourceShareAssociationsResponse::nextToken)).setter(GetResourceShareAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ResourceShareAssociation> resourceShareAssociations;
    private final String nextToken;

    private GetResourceShareAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShareAssociations = builder.resourceShareAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceShareAssociations() {
        return this.resourceShareAssociations != null && !(this.resourceShareAssociations instanceof SdkAutoConstructList);
    }

    public final List<ResourceShareAssociation> resourceShareAssociations() {
        return this.resourceShareAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceShareAssociations() ? this.resourceShareAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceShareAssociationsResponse)) {
            return false;
        }
        GetResourceShareAssociationsResponse other = (GetResourceShareAssociationsResponse)((Object)obj);
        return this.hasResourceShareAssociations() == other.hasResourceShareAssociations() && Objects.equals(this.resourceShareAssociations(), other.resourceShareAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceShareAssociationsResponse").add("ResourceShareAssociations", this.hasResourceShareAssociations() ? this.resourceShareAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareAssociations": {
                return Optional.ofNullable(clazz.cast(this.resourceShareAssociations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceShareAssociationsResponse, T> g) {
        return obj -> g.apply((GetResourceShareAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private List<ResourceShareAssociation> resourceShareAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceShareAssociationsResponse model) {
            super(model);
            this.resourceShareAssociations(model.resourceShareAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<ResourceShareAssociation.Builder> getResourceShareAssociations() {
            List<ResourceShareAssociation.Builder> result = ResourceShareAssociationListCopier.copyToBuilder(this.resourceShareAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceShareAssociations(Collection<ResourceShareAssociation.BuilderImpl> resourceShareAssociations) {
            this.resourceShareAssociations = ResourceShareAssociationListCopier.copyFromBuilder(resourceShareAssociations);
        }

        @Override
        public final Builder resourceShareAssociations(Collection<ResourceShareAssociation> resourceShareAssociations) {
            this.resourceShareAssociations = ResourceShareAssociationListCopier.copy(resourceShareAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareAssociations(ResourceShareAssociation ... resourceShareAssociations) {
            this.resourceShareAssociations(Arrays.asList(resourceShareAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareAssociations(Consumer<ResourceShareAssociation.Builder> ... resourceShareAssociations) {
            this.resourceShareAssociations(Stream.of(resourceShareAssociations).map(c -> (ResourceShareAssociation)((ResourceShareAssociation.Builder)ResourceShareAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetResourceShareAssociationsResponse build() {
            return new GetResourceShareAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceShareAssociationsResponse> {
        public Builder resourceShareAssociations(Collection<ResourceShareAssociation> var1);

        public Builder resourceShareAssociations(ResourceShareAssociation ... var1);

        public Builder resourceShareAssociations(Consumer<ResourceShareAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

