/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamAsyncClient;
import software.amazon.awssdk.services.ram.model.ListResourceTypesRequest;
import software.amazon.awssdk.services.ram.model.ListResourceTypesResponse;

public class ListResourceTypesPublisher
implements SdkPublisher<ListResourceTypesResponse> {
    private final RamAsyncClient client;
    private final ListResourceTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceTypesPublisher(RamAsyncClient client, ListResourceTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceTypesPublisher(RamAsyncClient client, ListResourceTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListResourceTypesResponseFetcher
    implements AsyncPageFetcher<ListResourceTypesResponse> {
        private ListResourceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceTypesResponse> nextPage(ListResourceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListResourceTypesPublisher.this.client.listResourceTypes(ListResourceTypesPublisher.this.firstRequest);
            }
            return ListResourceTypesPublisher.this.client.listResourceTypes((ListResourceTypesRequest)((Object)ListResourceTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

