/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.model.ListPermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionsResponse;

public class ListPermissionsIterable
implements SdkIterable<ListPermissionsResponse> {
    private final RamClient client;
    private final ListPermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPermissionsIterable(RamClient client, ListPermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPermissionsResponseFetcher();
    }

    public Iterator<ListPermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPermissionsResponseFetcher
    implements SyncPageFetcher<ListPermissionsResponse> {
        private ListPermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPermissionsResponse nextPage(ListPermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionsIterable.this.client.listPermissions(ListPermissionsIterable.this.firstRequest);
            }
            return ListPermissionsIterable.this.client.listPermissions((ListPermissionsRequest)((Object)ListPermissionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

