/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.Group;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGroupResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, CreateGroupResponse> {
    private static final SdkField<Group> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateGroupResponse.getter(CreateGroupResponse::group)).setter(CreateGroupResponse.setter(Builder::group)).constructor(Group::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGroupResponse.getter(CreateGroupResponse::requestId)).setter(CreateGroupResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateGroupResponse.getter(CreateGroupResponse::status)).setter(CreateGroupResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final Group group;
    private final String requestId;
    private final Integer status;

    private CreateGroupResponse(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public Group group() {
        return this.group;
    }

    public String requestId() {
        return this.requestId;
    }

    public Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupResponse)) {
            return false;
        }
        CreateGroupResponse other = (CreateGroupResponse)((Object)obj);
        return Objects.equals(this.group(), other.group()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"CreateGroupResponse").add("Group", (Object)this.group()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupResponse, T> g) {
        return obj -> g.apply((CreateGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Group group;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupResponse model) {
            super(model);
            this.group(model.group);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final Group.Builder getGroup() {
            return this.group != null ? this.group.toBuilder() : null;
        }

        @Override
        public final Builder group(Group group) {
            this.group = group;
            return this;
        }

        public final void setGroup(Group.BuilderImpl group) {
            this.group = group != null ? group.build() : null;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public CreateGroupResponse build() {
            return new CreateGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGroupResponse> {
        public Builder group(Group var1);

        default public Builder group(Consumer<Group.Builder> group) {
            return this.group((Group)((Group.Builder)Group.builder().applyMutation(group)).build());
        }

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

