/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateThemeResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateThemeResponse> {
    private static final SdkField<String> THEME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeId").getter(UpdateThemeResponse.getter(UpdateThemeResponse::themeId)).setter(UpdateThemeResponse.setter(Builder::themeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateThemeResponse.getter(UpdateThemeResponse::arn)).setter(UpdateThemeResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionArn").getter(UpdateThemeResponse.getter(UpdateThemeResponse::versionArn)).setter(UpdateThemeResponse.setter(Builder::versionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionArn").build()}).build();
    private static final SdkField<String> CREATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationStatus").getter(UpdateThemeResponse.getter(UpdateThemeResponse::creationStatusAsString)).setter(UpdateThemeResponse.setter(Builder::creationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationStatus").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(UpdateThemeResponse.getter(UpdateThemeResponse::status)).setter(UpdateThemeResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateThemeResponse.getter(UpdateThemeResponse::requestId)).setter(UpdateThemeResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THEME_ID_FIELD, ARN_FIELD, VERSION_ARN_FIELD, CREATION_STATUS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateThemeResponse.memberNameToFieldInitializer();
    private final String themeId;
    private final String arn;
    private final String versionArn;
    private final String creationStatus;
    private final Integer status;
    private final String requestId;

    private UpdateThemeResponse(BuilderImpl builder) {
        super(builder);
        this.themeId = builder.themeId;
        this.arn = builder.arn;
        this.versionArn = builder.versionArn;
        this.creationStatus = builder.creationStatus;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final String themeId() {
        return this.themeId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String versionArn() {
        return this.versionArn;
    }

    public final ResourceStatus creationStatus() {
        return ResourceStatus.fromValue(this.creationStatus);
    }

    public final String creationStatusAsString() {
        return this.creationStatus;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.themeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThemeResponse)) {
            return false;
        }
        UpdateThemeResponse other = (UpdateThemeResponse)((Object)obj);
        return Objects.equals(this.themeId(), other.themeId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.versionArn(), other.versionArn()) && Objects.equals(this.creationStatusAsString(), other.creationStatusAsString()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateThemeResponse").add("ThemeId", (Object)this.themeId()).add("Arn", (Object)this.arn()).add("VersionArn", (Object)this.versionArn()).add("CreationStatus", (Object)this.creationStatusAsString()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThemeId": {
                return Optional.ofNullable(clazz.cast(this.themeId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "VersionArn": {
                return Optional.ofNullable(clazz.cast(this.versionArn()));
            }
            case "CreationStatus": {
                return Optional.ofNullable(clazz.cast(this.creationStatusAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ThemeId", THEME_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("VersionArn", VERSION_ARN_FIELD);
        map.put("CreationStatus", CREATION_STATUS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateThemeResponse, T> g) {
        return obj -> g.apply((UpdateThemeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String themeId;
        private String arn;
        private String versionArn;
        private String creationStatus;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThemeResponse model) {
            super(model);
            this.themeId(model.themeId);
            this.arn(model.arn);
            this.versionArn(model.versionArn);
            this.creationStatus(model.creationStatus);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final String getThemeId() {
            return this.themeId;
        }

        public final void setThemeId(String themeId) {
            this.themeId = themeId;
        }

        @Override
        public final Builder themeId(String themeId) {
            this.themeId = themeId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getVersionArn() {
            return this.versionArn;
        }

        public final void setVersionArn(String versionArn) {
            this.versionArn = versionArn;
        }

        @Override
        public final Builder versionArn(String versionArn) {
            this.versionArn = versionArn;
            return this;
        }

        public final String getCreationStatus() {
            return this.creationStatus;
        }

        public final void setCreationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
        }

        @Override
        public final Builder creationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
            return this;
        }

        @Override
        public final Builder creationStatus(ResourceStatus creationStatus) {
            this.creationStatus(creationStatus == null ? null : creationStatus.toString());
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public UpdateThemeResponse build() {
            return new UpdateThemeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateThemeResponse> {
        public Builder themeId(String var1);

        public Builder arn(String var1);

        public Builder versionArn(String var1);

        public Builder creationStatus(String var1);

        public Builder creationStatus(ResourceStatus var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

