/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.Computation;
import software.amazon.awssdk.services.quicksight.model.ComputationListCopier;
import software.amazon.awssdk.services.quicksight.model.CustomNarrativeOptions;
import software.amazon.awssdk.services.quicksight.model.VisualInteractionOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightConfiguration> {
    private static final SdkField<List<Computation>> COMPUTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Computations").getter(InsightConfiguration.getter(InsightConfiguration::computations)).setter(InsightConfiguration.setter(Builder::computations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Computations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Computation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CustomNarrativeOptions> CUSTOM_NARRATIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomNarrative").getter(InsightConfiguration.getter(InsightConfiguration::customNarrative)).setter(InsightConfiguration.setter(Builder::customNarrative)).constructor(CustomNarrativeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomNarrative").build()}).build();
    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interactions").getter(InsightConfiguration.getter(InsightConfiguration::interactions)).setter(InsightConfiguration.setter(Builder::interactions)).constructor(VisualInteractionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATIONS_FIELD, CUSTOM_NARRATIVE_FIELD, INTERACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InsightConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Computation> computations;
    private final CustomNarrativeOptions customNarrative;
    private final VisualInteractionOptions interactions;

    private InsightConfiguration(BuilderImpl builder) {
        this.computations = builder.computations;
        this.customNarrative = builder.customNarrative;
        this.interactions = builder.interactions;
    }

    public final boolean hasComputations() {
        return this.computations != null && !(this.computations instanceof SdkAutoConstructList);
    }

    public final List<Computation> computations() {
        return this.computations;
    }

    public final CustomNarrativeOptions customNarrative() {
        return this.customNarrative;
    }

    public final VisualInteractionOptions interactions() {
        return this.interactions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputations() ? this.computations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customNarrative());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightConfiguration)) {
            return false;
        }
        InsightConfiguration other = (InsightConfiguration)obj;
        return this.hasComputations() == other.hasComputations() && Objects.equals(this.computations(), other.computations()) && Objects.equals(this.customNarrative(), other.customNarrative()) && Objects.equals(this.interactions(), other.interactions());
    }

    public final String toString() {
        return ToString.builder((String)"InsightConfiguration").add("Computations", this.hasComputations() ? this.computations() : null).add("CustomNarrative", (Object)this.customNarrative()).add("Interactions", (Object)this.interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Computations": {
                return Optional.ofNullable(clazz.cast(this.computations()));
            }
            case "CustomNarrative": {
                return Optional.ofNullable(clazz.cast(this.customNarrative()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Computations", COMPUTATIONS_FIELD);
        map.put("CustomNarrative", CUSTOM_NARRATIVE_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightConfiguration, T> g) {
        return obj -> g.apply((InsightConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Computation> computations = DefaultSdkAutoConstructList.getInstance();
        private CustomNarrativeOptions customNarrative;
        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightConfiguration model) {
            this.computations(model.computations);
            this.customNarrative(model.customNarrative);
            this.interactions(model.interactions);
        }

        public final List<Computation.Builder> getComputations() {
            List<Computation.Builder> result = ComputationListCopier.copyToBuilder(this.computations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputations(Collection<Computation.BuilderImpl> computations) {
            this.computations = ComputationListCopier.copyFromBuilder(computations);
        }

        @Override
        public final Builder computations(Collection<Computation> computations) {
            this.computations = ComputationListCopier.copy(computations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computations(Computation ... computations) {
            this.computations(Arrays.asList(computations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computations(Consumer<Computation.Builder> ... computations) {
            this.computations(Stream.of(computations).map(c -> (Computation)((Computation.Builder)Computation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CustomNarrativeOptions.Builder getCustomNarrative() {
            return this.customNarrative != null ? this.customNarrative.toBuilder() : null;
        }

        public final void setCustomNarrative(CustomNarrativeOptions.BuilderImpl customNarrative) {
            this.customNarrative = customNarrative != null ? customNarrative.build() : null;
        }

        @Override
        public final Builder customNarrative(CustomNarrativeOptions customNarrative) {
            this.customNarrative = customNarrative;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return this.interactions != null ? this.interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public InsightConfiguration build() {
            return new InsightConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightConfiguration> {
        public Builder computations(Collection<Computation> var1);

        public Builder computations(Computation ... var1);

        public Builder computations(Consumer<Computation.Builder> ... var1);

        public Builder customNarrative(CustomNarrativeOptions var1);

        default public Builder customNarrative(Consumer<CustomNarrativeOptions.Builder> customNarrative) {
            return this.customNarrative((CustomNarrativeOptions)((CustomNarrativeOptions.Builder)CustomNarrativeOptions.builder().applyMutation(customNarrative)).build());
        }

        public Builder interactions(VisualInteractionOptions var1);

        default public Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return this.interactions((VisualInteractionOptions)((VisualInteractionOptions.Builder)VisualInteractionOptions.builder().applyMutation(interactions)).build());
        }
    }
}

