/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteThemeAliasResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DeleteThemeAliasResponse> {
    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasName").getter(DeleteThemeAliasResponse.getter(DeleteThemeAliasResponse::aliasName)).setter(DeleteThemeAliasResponse.setter(Builder::aliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DeleteThemeAliasResponse.getter(DeleteThemeAliasResponse::arn)).setter(DeleteThemeAliasResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DeleteThemeAliasResponse.getter(DeleteThemeAliasResponse::requestId)).setter(DeleteThemeAliasResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DeleteThemeAliasResponse.getter(DeleteThemeAliasResponse::status)).setter(DeleteThemeAliasResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> THEME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeId").getter(DeleteThemeAliasResponse.getter(DeleteThemeAliasResponse::themeId)).setter(DeleteThemeAliasResponse.setter(Builder::themeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_NAME_FIELD, ARN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD, THEME_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteThemeAliasResponse.memberNameToFieldInitializer();
    private final String aliasName;
    private final String arn;
    private final String requestId;
    private final Integer status;
    private final String themeId;

    private DeleteThemeAliasResponse(BuilderImpl builder) {
        super(builder);
        this.aliasName = builder.aliasName;
        this.arn = builder.arn;
        this.requestId = builder.requestId;
        this.status = builder.status;
        this.themeId = builder.themeId;
    }

    public final String aliasName() {
        return this.aliasName;
    }

    public final String arn() {
        return this.arn;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final String themeId() {
        return this.themeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteThemeAliasResponse)) {
            return false;
        }
        DeleteThemeAliasResponse other = (DeleteThemeAliasResponse)((Object)obj);
        return Objects.equals(this.aliasName(), other.aliasName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.themeId(), other.themeId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteThemeAliasResponse").add("AliasName", (Object)this.aliasName()).add("Arn", (Object)this.arn()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).add("ThemeId", (Object)this.themeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasName": {
                return Optional.ofNullable(clazz.cast(this.aliasName()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "ThemeId": {
                return Optional.ofNullable(clazz.cast(this.themeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AliasName", ALIAS_NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ThemeId", THEME_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteThemeAliasResponse, T> g) {
        return obj -> g.apply((DeleteThemeAliasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String aliasName;
        private String arn;
        private String requestId;
        private Integer status;
        private String themeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteThemeAliasResponse model) {
            super(model);
            this.aliasName(model.aliasName);
            this.arn(model.arn);
            this.requestId(model.requestId);
            this.status(model.status);
            this.themeId(model.themeId);
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getThemeId() {
            return this.themeId;
        }

        public final void setThemeId(String themeId) {
            this.themeId = themeId;
        }

        @Override
        public final Builder themeId(String themeId) {
            this.themeId = themeId;
            return this;
        }

        @Override
        public DeleteThemeAliasResponse build() {
            return new DeleteThemeAliasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteThemeAliasResponse> {
        public Builder aliasName(String var1);

        public Builder arn(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);

        public Builder themeId(String var1);
    }
}

