/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserCustomPermissionRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateUserCustomPermissionRequest.Builder, UpdateUserCustomPermissionRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(UpdateUserCustomPermissionRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserName").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateUserCustomPermissionRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(UpdateUserCustomPermissionRequest::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()).build();

    private static final SdkField<String> CUSTOM_PERMISSIONS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomPermissionsName").getter(getter(UpdateUserCustomPermissionRequest::customPermissionsName))
            .setter(setter(Builder::customPermissionsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPermissionsName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD, CUSTOM_PERMISSIONS_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userName;

    private final String awsAccountId;

    private final String namespace;

    private final String customPermissionsName;

    private UpdateUserCustomPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.customPermissionsName = builder.customPermissionsName;
    }

    /**
     * <p>
     * The username of the user that you want to update custom permissions for.
     * </p>
     * 
     * @return The username of the user that you want to update custom permissions for.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the custom permission configuration that you want to
     * update.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the custom permission configuration that you want
     *         to update.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The namespace that the user belongs to.
     * </p>
     * 
     * @return The namespace that the user belongs to.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the custom permissions that you want to update.
     * </p>
     * 
     * @return The name of the custom permissions that you want to update.
     */
    public final String customPermissionsName() {
        return customPermissionsName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(customPermissionsName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserCustomPermissionRequest)) {
            return false;
        }
        UpdateUserCustomPermissionRequest other = (UpdateUserCustomPermissionRequest) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(namespace(), other.namespace())
                && Objects.equals(customPermissionsName(), other.customPermissionsName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserCustomPermissionRequest").add("UserName", userName())
                .add("AwsAccountId", awsAccountId()).add("Namespace", namespace())
                .add("CustomPermissionsName", customPermissionsName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "CustomPermissionsName":
            return Optional.ofNullable(clazz.cast(customPermissionsName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserName", USER_NAME_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("CustomPermissionsName", CUSTOM_PERMISSIONS_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserCustomPermissionRequest, T> g) {
        return obj -> g.apply((UpdateUserCustomPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateUserCustomPermissionRequest> {
        /**
         * <p>
         * The username of the user that you want to update custom permissions for.
         * </p>
         * 
         * @param userName
         *        The username of the user that you want to update custom permissions for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the custom permission configuration that you want to
         * update.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the custom permission configuration that you
         *        want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The namespace that the user belongs to.
         * </p>
         * 
         * @param namespace
         *        The namespace that the user belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the custom permissions that you want to update.
         * </p>
         * 
         * @param customPermissionsName
         *        The name of the custom permissions that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPermissionsName(String customPermissionsName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String userName;

        private String awsAccountId;

        private String namespace;

        private String customPermissionsName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserCustomPermissionRequest model) {
            super(model);
            userName(model.userName);
            awsAccountId(model.awsAccountId);
            namespace(model.namespace);
            customPermissionsName(model.customPermissionsName);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getCustomPermissionsName() {
            return customPermissionsName;
        }

        public final void setCustomPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
        }

        @Override
        public final Builder customPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserCustomPermissionRequest build() {
            return new UpdateUserCustomPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
