/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePublicSharingSettingsRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdatePublicSharingSettingsRequest.Builder, UpdatePublicSharingSettingsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdatePublicSharingSettingsRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<Boolean> PUBLIC_SHARING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PublicSharingEnabled").getter(getter(UpdatePublicSharingSettingsRequest::publicSharingEnabled))
            .setter(setter(Builder::publicSharingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSharingEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            PUBLIC_SHARING_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final Boolean publicSharingEnabled;

    private UpdatePublicSharingSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.publicSharingEnabled = builder.publicSharingEnabled;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with your QuickSight subscription.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with your QuickSight subscription.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * A Boolean value that indicates whether public sharing is turned on for an QuickSight account.
     * </p>
     * 
     * @return A Boolean value that indicates whether public sharing is turned on for an QuickSight account.
     */
    public final Boolean publicSharingEnabled() {
        return publicSharingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(publicSharingEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePublicSharingSettingsRequest)) {
            return false;
        }
        UpdatePublicSharingSettingsRequest other = (UpdatePublicSharingSettingsRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(publicSharingEnabled(), other.publicSharingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePublicSharingSettingsRequest").add("AwsAccountId", awsAccountId())
                .add("PublicSharingEnabled", publicSharingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "PublicSharingEnabled":
            return Optional.ofNullable(clazz.cast(publicSharingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("PublicSharingEnabled", PUBLIC_SHARING_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePublicSharingSettingsRequest, T> g) {
        return obj -> g.apply((UpdatePublicSharingSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePublicSharingSettingsRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with your QuickSight subscription.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID associated with your QuickSight subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * A Boolean value that indicates whether public sharing is turned on for an QuickSight account.
         * </p>
         * 
         * @param publicSharingEnabled
         *        A Boolean value that indicates whether public sharing is turned on for an QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicSharingEnabled(Boolean publicSharingEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private Boolean publicSharingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePublicSharingSettingsRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            publicSharingEnabled(model.publicSharingEnabled);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Boolean getPublicSharingEnabled() {
            return publicSharingEnabled;
        }

        public final void setPublicSharingEnabled(Boolean publicSharingEnabled) {
            this.publicSharingEnabled = publicSharingEnabled;
        }

        @Override
        public final Builder publicSharingEnabled(Boolean publicSharingEnabled) {
            this.publicSharingEnabled = publicSharingEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePublicSharingSettingsRequest build() {
            return new UpdatePublicSharingSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
