/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The total aggregation computation configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TotalAggregationComputation implements SdkPojo, Serializable,
        ToCopyableBuilder<TotalAggregationComputation.Builder, TotalAggregationComputation> {
    private static final SdkField<String> COMPUTATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputationId").getter(getter(TotalAggregationComputation::computationId))
            .setter(setter(Builder::computationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TotalAggregationComputation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<MeasureField> VALUE_FIELD = SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
            .memberName("Value").getter(getter(TotalAggregationComputation::value)).setter(setter(Builder::value))
            .constructor(MeasureField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_ID_FIELD,
            NAME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String computationId;

    private final String name;

    private final MeasureField value;

    private TotalAggregationComputation(BuilderImpl builder) {
        this.computationId = builder.computationId;
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The ID for a computation.
     * </p>
     * 
     * @return The ID for a computation.
     */
    public final String computationId() {
        return computationId;
    }

    /**
     * <p>
     * The name of a computation.
     * </p>
     * 
     * @return The name of a computation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The value field that is used in a computation.
     * </p>
     * 
     * @return The value field that is used in a computation.
     */
    public final MeasureField value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TotalAggregationComputation)) {
            return false;
        }
        TotalAggregationComputation other = (TotalAggregationComputation) obj;
        return Objects.equals(computationId(), other.computationId()) && Objects.equals(name(), other.name())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TotalAggregationComputation").add("ComputationId", computationId()).add("Name", name())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputationId":
            return Optional.ofNullable(clazz.cast(computationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComputationId", COMPUTATION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TotalAggregationComputation, T> g) {
        return obj -> g.apply((TotalAggregationComputation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TotalAggregationComputation> {
        /**
         * <p>
         * The ID for a computation.
         * </p>
         * 
         * @param computationId
         *        The ID for a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationId(String computationId);

        /**
         * <p>
         * The name of a computation.
         * </p>
         * 
         * @param name
         *        The name of a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value field that is used in a computation.
         * </p>
         * 
         * @param value
         *        The value field that is used in a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(MeasureField value);

        /**
         * <p>
         * The value field that is used in a computation.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeasureField.Builder} avoiding the need
         * to create one manually via {@link MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeasureField.Builder#build()} is called immediately and its
         * result is passed to {@link #value(MeasureField)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(MeasureField)
         */
        default Builder value(Consumer<MeasureField.Builder> value) {
            return value(MeasureField.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String computationId;

        private String name;

        private MeasureField value;

        private BuilderImpl() {
        }

        private BuilderImpl(TotalAggregationComputation model) {
            computationId(model.computationId);
            name(model.name);
            value(model.value);
        }

        public final String getComputationId() {
            return computationId;
        }

        public final void setComputationId(String computationId) {
            this.computationId = computationId;
        }

        @Override
        public final Builder computationId(String computationId) {
            this.computationId = computationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final MeasureField.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(MeasureField.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MeasureField value) {
            this.value = value;
            return this;
        }

        @Override
        public TotalAggregationComputation build() {
            return new TotalAggregationComputation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
