/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the thousands separator configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThousandSeparatorOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ThousandSeparatorOptions.Builder, ThousandSeparatorOptions> {
    private static final SdkField<String> SYMBOL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Symbol")
            .getter(getter(ThousandSeparatorOptions::symbolAsString)).setter(setter(Builder::symbol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Symbol").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(ThousandSeparatorOptions::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<String> GROUPING_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupingStyle").getter(getter(ThousandSeparatorOptions::groupingStyleAsString))
            .setter(setter(Builder::groupingStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingStyle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYMBOL_FIELD,
            VISIBILITY_FIELD, GROUPING_STYLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String symbol;

    private final String visibility;

    private final String groupingStyle;

    private ThousandSeparatorOptions(BuilderImpl builder) {
        this.symbol = builder.symbol;
        this.visibility = builder.visibility;
        this.groupingStyle = builder.groupingStyle;
    }

    /**
     * <p>
     * Determines the thousands separator symbol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #symbol} will
     * return {@link NumericSeparatorSymbol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #symbolAsString}.
     * </p>
     * 
     * @return Determines the thousands separator symbol.
     * @see NumericSeparatorSymbol
     */
    public final NumericSeparatorSymbol symbol() {
        return NumericSeparatorSymbol.fromValue(symbol);
    }

    /**
     * <p>
     * Determines the thousands separator symbol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #symbol} will
     * return {@link NumericSeparatorSymbol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #symbolAsString}.
     * </p>
     * 
     * @return Determines the thousands separator symbol.
     * @see NumericSeparatorSymbol
     */
    public final String symbolAsString() {
        return symbol;
    }

    /**
     * <p>
     * Determines the visibility of the thousands separator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the thousands separator.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * Determines the visibility of the thousands separator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the thousands separator.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * Determines the way numbers are styled to accommodate different readability standards. The <code>DEFAULT</code>
     * value uses the standard international grouping system and groups numbers by the thousands. The <code>LAKHS</code>
     * value uses the Indian numbering system and groups numbers by lakhs and crores.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupingStyle}
     * will return {@link DigitGroupingStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #groupingStyleAsString}.
     * </p>
     * 
     * @return Determines the way numbers are styled to accommodate different readability standards. The
     *         <code>DEFAULT</code> value uses the standard international grouping system and groups numbers by the
     *         thousands. The <code>LAKHS</code> value uses the Indian numbering system and groups numbers by lakhs and
     *         crores.
     * @see DigitGroupingStyle
     */
    public final DigitGroupingStyle groupingStyle() {
        return DigitGroupingStyle.fromValue(groupingStyle);
    }

    /**
     * <p>
     * Determines the way numbers are styled to accommodate different readability standards. The <code>DEFAULT</code>
     * value uses the standard international grouping system and groups numbers by the thousands. The <code>LAKHS</code>
     * value uses the Indian numbering system and groups numbers by lakhs and crores.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupingStyle}
     * will return {@link DigitGroupingStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #groupingStyleAsString}.
     * </p>
     * 
     * @return Determines the way numbers are styled to accommodate different readability standards. The
     *         <code>DEFAULT</code> value uses the standard international grouping system and groups numbers by the
     *         thousands. The <code>LAKHS</code> value uses the Indian numbering system and groups numbers by lakhs and
     *         crores.
     * @see DigitGroupingStyle
     */
    public final String groupingStyleAsString() {
        return groupingStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(symbolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupingStyleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThousandSeparatorOptions)) {
            return false;
        }
        ThousandSeparatorOptions other = (ThousandSeparatorOptions) obj;
        return Objects.equals(symbolAsString(), other.symbolAsString())
                && Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(groupingStyleAsString(), other.groupingStyleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThousandSeparatorOptions").add("Symbol", symbolAsString())
                .add("Visibility", visibilityAsString()).add("GroupingStyle", groupingStyleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Symbol":
            return Optional.ofNullable(clazz.cast(symbolAsString()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "GroupingStyle":
            return Optional.ofNullable(clazz.cast(groupingStyleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Symbol", SYMBOL_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("GroupingStyle", GROUPING_STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThousandSeparatorOptions, T> g) {
        return obj -> g.apply((ThousandSeparatorOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThousandSeparatorOptions> {
        /**
         * <p>
         * Determines the thousands separator symbol.
         * </p>
         * 
         * @param symbol
         *        Determines the thousands separator symbol.
         * @see NumericSeparatorSymbol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericSeparatorSymbol
         */
        Builder symbol(String symbol);

        /**
         * <p>
         * Determines the thousands separator symbol.
         * </p>
         * 
         * @param symbol
         *        Determines the thousands separator symbol.
         * @see NumericSeparatorSymbol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericSeparatorSymbol
         */
        Builder symbol(NumericSeparatorSymbol symbol);

        /**
         * <p>
         * Determines the visibility of the thousands separator.
         * </p>
         * 
         * @param visibility
         *        Determines the visibility of the thousands separator.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * Determines the visibility of the thousands separator.
         * </p>
         * 
         * @param visibility
         *        Determines the visibility of the thousands separator.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * Determines the way numbers are styled to accommodate different readability standards. The
         * <code>DEFAULT</code> value uses the standard international grouping system and groups numbers by the
         * thousands. The <code>LAKHS</code> value uses the Indian numbering system and groups numbers by lakhs and
         * crores.
         * </p>
         * 
         * @param groupingStyle
         *        Determines the way numbers are styled to accommodate different readability standards. The
         *        <code>DEFAULT</code> value uses the standard international grouping system and groups numbers by the
         *        thousands. The <code>LAKHS</code> value uses the Indian numbering system and groups numbers by lakhs
         *        and crores.
         * @see DigitGroupingStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DigitGroupingStyle
         */
        Builder groupingStyle(String groupingStyle);

        /**
         * <p>
         * Determines the way numbers are styled to accommodate different readability standards. The
         * <code>DEFAULT</code> value uses the standard international grouping system and groups numbers by the
         * thousands. The <code>LAKHS</code> value uses the Indian numbering system and groups numbers by lakhs and
         * crores.
         * </p>
         * 
         * @param groupingStyle
         *        Determines the way numbers are styled to accommodate different readability standards. The
         *        <code>DEFAULT</code> value uses the standard international grouping system and groups numbers by the
         *        thousands. The <code>LAKHS</code> value uses the Indian numbering system and groups numbers by lakhs
         *        and crores.
         * @see DigitGroupingStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DigitGroupingStyle
         */
        Builder groupingStyle(DigitGroupingStyle groupingStyle);
    }

    static final class BuilderImpl implements Builder {
        private String symbol;

        private String visibility;

        private String groupingStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(ThousandSeparatorOptions model) {
            symbol(model.symbol);
            visibility(model.visibility);
            groupingStyle(model.groupingStyle);
        }

        public final String getSymbol() {
            return symbol;
        }

        public final void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        @Override
        public final Builder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        @Override
        public final Builder symbol(NumericSeparatorSymbol symbol) {
            this.symbol(symbol == null ? null : symbol.toString());
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getGroupingStyle() {
            return groupingStyle;
        }

        public final void setGroupingStyle(String groupingStyle) {
            this.groupingStyle = groupingStyle;
        }

        @Override
        public final Builder groupingStyle(String groupingStyle) {
            this.groupingStyle = groupingStyle;
            return this;
        }

        @Override
        public final Builder groupingStyle(DigitGroupingStyle groupingStyle) {
            this.groupingStyle(groupingStyle == null ? null : groupingStyle.toString());
            return this;
        }

        @Override
        public ThousandSeparatorOptions build() {
            return new ThousandSeparatorOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
