/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that determines the elements and canvas size options of sheet control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SheetControlLayoutConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SheetControlLayoutConfiguration.Builder, SheetControlLayoutConfiguration> {
    private static final SdkField<GridLayoutConfiguration> GRID_LAYOUT_FIELD = SdkField
            .<GridLayoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("GridLayout")
            .getter(getter(SheetControlLayoutConfiguration::gridLayout)).setter(setter(Builder::gridLayout))
            .constructor(GridLayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GridLayout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRID_LAYOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GridLayoutConfiguration gridLayout;

    private SheetControlLayoutConfiguration(BuilderImpl builder) {
        this.gridLayout = builder.gridLayout;
    }

    /**
     * <p>
     * The configuration that determines the elements and canvas size options of sheet control.
     * </p>
     * 
     * @return The configuration that determines the elements and canvas size options of sheet control.
     */
    public final GridLayoutConfiguration gridLayout() {
        return gridLayout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gridLayout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetControlLayoutConfiguration)) {
            return false;
        }
        SheetControlLayoutConfiguration other = (SheetControlLayoutConfiguration) obj;
        return Objects.equals(gridLayout(), other.gridLayout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SheetControlLayoutConfiguration").add("GridLayout", gridLayout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GridLayout":
            return Optional.ofNullable(clazz.cast(gridLayout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GridLayout", GRID_LAYOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetControlLayoutConfiguration, T> g) {
        return obj -> g.apply((SheetControlLayoutConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SheetControlLayoutConfiguration> {
        /**
         * <p>
         * The configuration that determines the elements and canvas size options of sheet control.
         * </p>
         * 
         * @param gridLayout
         *        The configuration that determines the elements and canvas size options of sheet control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gridLayout(GridLayoutConfiguration gridLayout);

        /**
         * <p>
         * The configuration that determines the elements and canvas size options of sheet control.
         * </p>
         * This is a convenience method that creates an instance of the {@link GridLayoutConfiguration.Builder} avoiding
         * the need to create one manually via {@link GridLayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GridLayoutConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #gridLayout(GridLayoutConfiguration)}.
         * 
         * @param gridLayout
         *        a consumer that will call methods on {@link GridLayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gridLayout(GridLayoutConfiguration)
         */
        default Builder gridLayout(Consumer<GridLayoutConfiguration.Builder> gridLayout) {
            return gridLayout(GridLayoutConfiguration.builder().applyMutation(gridLayout).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GridLayoutConfiguration gridLayout;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetControlLayoutConfiguration model) {
            gridLayout(model.gridLayout);
        }

        public final GridLayoutConfiguration.Builder getGridLayout() {
            return gridLayout != null ? gridLayout.toBuilder() : null;
        }

        public final void setGridLayout(GridLayoutConfiguration.BuilderImpl gridLayout) {
            this.gridLayout = gridLayout != null ? gridLayout.build() : null;
        }

        @Override
        public final Builder gridLayout(GridLayoutConfiguration gridLayout) {
            this.gridLayout = gridLayout;
            return this;
        }

        @Override
        public SheetControlLayoutConfiguration build() {
            return new SheetControlLayoutConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
