/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sort configuration of a sankey diagram.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SankeyDiagramSortConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SankeyDiagramSortConfiguration.Builder, SankeyDiagramSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> WEIGHT_SORT_FIELD = SdkField
            .<List<FieldSortOptions>> builder(MarshallingType.LIST)
            .memberName("WeightSort")
            .getter(getter(SankeyDiagramSortConfiguration::weightSort))
            .setter(setter(Builder::weightSort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightSort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldSortOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldSortOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ItemsLimitConfiguration> SOURCE_ITEMS_LIMIT_FIELD = SdkField
            .<ItemsLimitConfiguration> builder(MarshallingType.SDK_POJO).memberName("SourceItemsLimit")
            .getter(getter(SankeyDiagramSortConfiguration::sourceItemsLimit)).setter(setter(Builder::sourceItemsLimit))
            .constructor(ItemsLimitConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceItemsLimit").build()).build();

    private static final SdkField<ItemsLimitConfiguration> DESTINATION_ITEMS_LIMIT_FIELD = SdkField
            .<ItemsLimitConfiguration> builder(MarshallingType.SDK_POJO).memberName("DestinationItemsLimit")
            .getter(getter(SankeyDiagramSortConfiguration::destinationItemsLimit)).setter(setter(Builder::destinationItemsLimit))
            .constructor(ItemsLimitConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationItemsLimit").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEIGHT_SORT_FIELD,
            SOURCE_ITEMS_LIMIT_FIELD, DESTINATION_ITEMS_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FieldSortOptions> weightSort;

    private final ItemsLimitConfiguration sourceItemsLimit;

    private final ItemsLimitConfiguration destinationItemsLimit;

    private SankeyDiagramSortConfiguration(BuilderImpl builder) {
        this.weightSort = builder.weightSort;
        this.sourceItemsLimit = builder.sourceItemsLimit;
        this.destinationItemsLimit = builder.destinationItemsLimit;
    }

    /**
     * For responses, this returns true if the service returned a value for the WeightSort property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWeightSort() {
        return weightSort != null && !(weightSort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sort configuration of the weight fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWeightSort} method.
     * </p>
     * 
     * @return The sort configuration of the weight fields.
     */
    public final List<FieldSortOptions> weightSort() {
        return weightSort;
    }

    /**
     * <p>
     * The limit on the number of source nodes that are displayed in a sankey diagram.
     * </p>
     * 
     * @return The limit on the number of source nodes that are displayed in a sankey diagram.
     */
    public final ItemsLimitConfiguration sourceItemsLimit() {
        return sourceItemsLimit;
    }

    /**
     * <p>
     * The limit on the number of destination nodes that are displayed in a sankey diagram.
     * </p>
     * 
     * @return The limit on the number of destination nodes that are displayed in a sankey diagram.
     */
    public final ItemsLimitConfiguration destinationItemsLimit() {
        return destinationItemsLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasWeightSort() ? weightSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceItemsLimit());
        hashCode = 31 * hashCode + Objects.hashCode(destinationItemsLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SankeyDiagramSortConfiguration)) {
            return false;
        }
        SankeyDiagramSortConfiguration other = (SankeyDiagramSortConfiguration) obj;
        return hasWeightSort() == other.hasWeightSort() && Objects.equals(weightSort(), other.weightSort())
                && Objects.equals(sourceItemsLimit(), other.sourceItemsLimit())
                && Objects.equals(destinationItemsLimit(), other.destinationItemsLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SankeyDiagramSortConfiguration").add("WeightSort", hasWeightSort() ? weightSort() : null)
                .add("SourceItemsLimit", sourceItemsLimit()).add("DestinationItemsLimit", destinationItemsLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WeightSort":
            return Optional.ofNullable(clazz.cast(weightSort()));
        case "SourceItemsLimit":
            return Optional.ofNullable(clazz.cast(sourceItemsLimit()));
        case "DestinationItemsLimit":
            return Optional.ofNullable(clazz.cast(destinationItemsLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WeightSort", WEIGHT_SORT_FIELD);
        map.put("SourceItemsLimit", SOURCE_ITEMS_LIMIT_FIELD);
        map.put("DestinationItemsLimit", DESTINATION_ITEMS_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SankeyDiagramSortConfiguration, T> g) {
        return obj -> g.apply((SankeyDiagramSortConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SankeyDiagramSortConfiguration> {
        /**
         * <p>
         * The sort configuration of the weight fields.
         * </p>
         * 
         * @param weightSort
         *        The sort configuration of the weight fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightSort(Collection<FieldSortOptions> weightSort);

        /**
         * <p>
         * The sort configuration of the weight fields.
         * </p>
         * 
         * @param weightSort
         *        The sort configuration of the weight fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightSort(FieldSortOptions... weightSort);

        /**
         * <p>
         * The sort configuration of the weight fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #weightSort(List<FieldSortOptions>)}.
         * 
         * @param weightSort
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #weightSort(java.util.Collection<FieldSortOptions>)
         */
        Builder weightSort(Consumer<FieldSortOptions.Builder>... weightSort);

        /**
         * <p>
         * The limit on the number of source nodes that are displayed in a sankey diagram.
         * </p>
         * 
         * @param sourceItemsLimit
         *        The limit on the number of source nodes that are displayed in a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceItemsLimit(ItemsLimitConfiguration sourceItemsLimit);

        /**
         * <p>
         * The limit on the number of source nodes that are displayed in a sankey diagram.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemsLimitConfiguration.Builder} avoiding
         * the need to create one manually via {@link ItemsLimitConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemsLimitConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceItemsLimit(ItemsLimitConfiguration)}.
         * 
         * @param sourceItemsLimit
         *        a consumer that will call methods on {@link ItemsLimitConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceItemsLimit(ItemsLimitConfiguration)
         */
        default Builder sourceItemsLimit(Consumer<ItemsLimitConfiguration.Builder> sourceItemsLimit) {
            return sourceItemsLimit(ItemsLimitConfiguration.builder().applyMutation(sourceItemsLimit).build());
        }

        /**
         * <p>
         * The limit on the number of destination nodes that are displayed in a sankey diagram.
         * </p>
         * 
         * @param destinationItemsLimit
         *        The limit on the number of destination nodes that are displayed in a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationItemsLimit(ItemsLimitConfiguration destinationItemsLimit);

        /**
         * <p>
         * The limit on the number of destination nodes that are displayed in a sankey diagram.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemsLimitConfiguration.Builder} avoiding
         * the need to create one manually via {@link ItemsLimitConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemsLimitConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationItemsLimit(ItemsLimitConfiguration)}.
         * 
         * @param destinationItemsLimit
         *        a consumer that will call methods on {@link ItemsLimitConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationItemsLimit(ItemsLimitConfiguration)
         */
        default Builder destinationItemsLimit(Consumer<ItemsLimitConfiguration.Builder> destinationItemsLimit) {
            return destinationItemsLimit(ItemsLimitConfiguration.builder().applyMutation(destinationItemsLimit).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<FieldSortOptions> weightSort = DefaultSdkAutoConstructList.getInstance();

        private ItemsLimitConfiguration sourceItemsLimit;

        private ItemsLimitConfiguration destinationItemsLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(SankeyDiagramSortConfiguration model) {
            weightSort(model.weightSort);
            sourceItemsLimit(model.sourceItemsLimit);
            destinationItemsLimit(model.destinationItemsLimit);
        }

        public final List<FieldSortOptions.Builder> getWeightSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.weightSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWeightSort(Collection<FieldSortOptions.BuilderImpl> weightSort) {
            this.weightSort = FieldSortOptionsListCopier.copyFromBuilder(weightSort);
        }

        @Override
        public final Builder weightSort(Collection<FieldSortOptions> weightSort) {
            this.weightSort = FieldSortOptionsListCopier.copy(weightSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightSort(FieldSortOptions... weightSort) {
            weightSort(Arrays.asList(weightSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightSort(Consumer<FieldSortOptions.Builder>... weightSort) {
            weightSort(Stream.of(weightSort).map(c -> FieldSortOptions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getSourceItemsLimit() {
            return sourceItemsLimit != null ? sourceItemsLimit.toBuilder() : null;
        }

        public final void setSourceItemsLimit(ItemsLimitConfiguration.BuilderImpl sourceItemsLimit) {
            this.sourceItemsLimit = sourceItemsLimit != null ? sourceItemsLimit.build() : null;
        }

        @Override
        public final Builder sourceItemsLimit(ItemsLimitConfiguration sourceItemsLimit) {
            this.sourceItemsLimit = sourceItemsLimit;
            return this;
        }

        public final ItemsLimitConfiguration.Builder getDestinationItemsLimit() {
            return destinationItemsLimit != null ? destinationItemsLimit.toBuilder() : null;
        }

        public final void setDestinationItemsLimit(ItemsLimitConfiguration.BuilderImpl destinationItemsLimit) {
            this.destinationItemsLimit = destinationItemsLimit != null ? destinationItemsLimit.build() : null;
        }

        @Override
        public final Builder destinationItemsLimit(ItemsLimitConfiguration destinationItemsLimit) {
            this.destinationItemsLimit = destinationItemsLimit;
            return this;
        }

        @Override
        public SankeyDiagramSortConfiguration build() {
            return new SankeyDiagramSortConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
