/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Line styles options for a line series in <code>LineChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineChartLineStyleSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<LineChartLineStyleSettings.Builder, LineChartLineStyleSettings> {
    private static final SdkField<String> LINE_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LineVisibility").getter(getter(LineChartLineStyleSettings::lineVisibilityAsString))
            .setter(setter(Builder::lineVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineVisibility").build()).build();

    private static final SdkField<String> LINE_INTERPOLATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LineInterpolation").getter(getter(LineChartLineStyleSettings::lineInterpolationAsString))
            .setter(setter(Builder::lineInterpolation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineInterpolation").build()).build();

    private static final SdkField<String> LINE_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LineStyle").getter(getter(LineChartLineStyleSettings::lineStyleAsString))
            .setter(setter(Builder::lineStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineStyle").build()).build();

    private static final SdkField<String> LINE_WIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LineWidth").getter(getter(LineChartLineStyleSettings::lineWidth)).setter(setter(Builder::lineWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineWidth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_VISIBILITY_FIELD,
            LINE_INTERPOLATION_FIELD, LINE_STYLE_FIELD, LINE_WIDTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lineVisibility;

    private final String lineInterpolation;

    private final String lineStyle;

    private final String lineWidth;

    private LineChartLineStyleSettings(BuilderImpl builder) {
        this.lineVisibility = builder.lineVisibility;
        this.lineInterpolation = builder.lineInterpolation;
        this.lineStyle = builder.lineStyle;
        this.lineWidth = builder.lineWidth;
    }

    /**
     * <p>
     * Configuration option that determines whether to show the line for the series.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lineVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lineVisibilityAsString}.
     * </p>
     * 
     * @return Configuration option that determines whether to show the line for the series.
     * @see Visibility
     */
    public final Visibility lineVisibility() {
        return Visibility.fromValue(lineVisibility);
    }

    /**
     * <p>
     * Configuration option that determines whether to show the line for the series.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lineVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lineVisibilityAsString}.
     * </p>
     * 
     * @return Configuration option that determines whether to show the line for the series.
     * @see Visibility
     */
    public final String lineVisibilityAsString() {
        return lineVisibility;
    }

    /**
     * <p>
     * Interpolation style for line series.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINEAR</code>: Show as default, linear style.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SMOOTH</code>: Show as a smooth curve.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STEPPED</code>: Show steps in line.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lineInterpolation}
     * will return {@link LineInterpolation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lineInterpolationAsString}.
     * </p>
     * 
     * @return Interpolation style for line series.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LINEAR</code>: Show as default, linear style.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SMOOTH</code>: Show as a smooth curve.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STEPPED</code>: Show steps in line.
     *         </p>
     *         </li>
     * @see LineInterpolation
     */
    public final LineInterpolation lineInterpolation() {
        return LineInterpolation.fromValue(lineInterpolation);
    }

    /**
     * <p>
     * Interpolation style for line series.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINEAR</code>: Show as default, linear style.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SMOOTH</code>: Show as a smooth curve.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STEPPED</code>: Show steps in line.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lineInterpolation}
     * will return {@link LineInterpolation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lineInterpolationAsString}.
     * </p>
     * 
     * @return Interpolation style for line series.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LINEAR</code>: Show as default, linear style.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SMOOTH</code>: Show as a smooth curve.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STEPPED</code>: Show steps in line.
     *         </p>
     *         </li>
     * @see LineInterpolation
     */
    public final String lineInterpolationAsString() {
        return lineInterpolation;
    }

    /**
     * <p>
     * Line style for line series.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SOLID</code>: Show as a solid line.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DOTTED</code>: Show as a dotted line.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DASHED</code>: Show as a dashed line.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lineStyle} will
     * return {@link LineChartLineStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lineStyleAsString}.
     * </p>
     * 
     * @return Line style for line series.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SOLID</code>: Show as a solid line.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DOTTED</code>: Show as a dotted line.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DASHED</code>: Show as a dashed line.
     *         </p>
     *         </li>
     * @see LineChartLineStyle
     */
    public final LineChartLineStyle lineStyle() {
        return LineChartLineStyle.fromValue(lineStyle);
    }

    /**
     * <p>
     * Line style for line series.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SOLID</code>: Show as a solid line.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DOTTED</code>: Show as a dotted line.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DASHED</code>: Show as a dashed line.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lineStyle} will
     * return {@link LineChartLineStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lineStyleAsString}.
     * </p>
     * 
     * @return Line style for line series.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SOLID</code>: Show as a solid line.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DOTTED</code>: Show as a dotted line.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DASHED</code>: Show as a dashed line.
     *         </p>
     *         </li>
     * @see LineChartLineStyle
     */
    public final String lineStyleAsString() {
        return lineStyle;
    }

    /**
     * <p>
     * Width that determines the line thickness.
     * </p>
     * 
     * @return Width that determines the line thickness.
     */
    public final String lineWidth() {
        return lineWidth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lineVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lineInterpolationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lineStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lineWidth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineChartLineStyleSettings)) {
            return false;
        }
        LineChartLineStyleSettings other = (LineChartLineStyleSettings) obj;
        return Objects.equals(lineVisibilityAsString(), other.lineVisibilityAsString())
                && Objects.equals(lineInterpolationAsString(), other.lineInterpolationAsString())
                && Objects.equals(lineStyleAsString(), other.lineStyleAsString())
                && Objects.equals(lineWidth(), other.lineWidth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineChartLineStyleSettings").add("LineVisibility", lineVisibilityAsString())
                .add("LineInterpolation", lineInterpolationAsString()).add("LineStyle", lineStyleAsString())
                .add("LineWidth", lineWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LineVisibility":
            return Optional.ofNullable(clazz.cast(lineVisibilityAsString()));
        case "LineInterpolation":
            return Optional.ofNullable(clazz.cast(lineInterpolationAsString()));
        case "LineStyle":
            return Optional.ofNullable(clazz.cast(lineStyleAsString()));
        case "LineWidth":
            return Optional.ofNullable(clazz.cast(lineWidth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LineVisibility", LINE_VISIBILITY_FIELD);
        map.put("LineInterpolation", LINE_INTERPOLATION_FIELD);
        map.put("LineStyle", LINE_STYLE_FIELD);
        map.put("LineWidth", LINE_WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineChartLineStyleSettings, T> g) {
        return obj -> g.apply((LineChartLineStyleSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineChartLineStyleSettings> {
        /**
         * <p>
         * Configuration option that determines whether to show the line for the series.
         * </p>
         * 
         * @param lineVisibility
         *        Configuration option that determines whether to show the line for the series.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder lineVisibility(String lineVisibility);

        /**
         * <p>
         * Configuration option that determines whether to show the line for the series.
         * </p>
         * 
         * @param lineVisibility
         *        Configuration option that determines whether to show the line for the series.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder lineVisibility(Visibility lineVisibility);

        /**
         * <p>
         * Interpolation style for line series.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LINEAR</code>: Show as default, linear style.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SMOOTH</code>: Show as a smooth curve.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STEPPED</code>: Show steps in line.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lineInterpolation
         *        Interpolation style for line series.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LINEAR</code>: Show as default, linear style.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SMOOTH</code>: Show as a smooth curve.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STEPPED</code>: Show steps in line.
         *        </p>
         *        </li>
         * @see LineInterpolation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineInterpolation
         */
        Builder lineInterpolation(String lineInterpolation);

        /**
         * <p>
         * Interpolation style for line series.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LINEAR</code>: Show as default, linear style.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SMOOTH</code>: Show as a smooth curve.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STEPPED</code>: Show steps in line.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lineInterpolation
         *        Interpolation style for line series.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LINEAR</code>: Show as default, linear style.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SMOOTH</code>: Show as a smooth curve.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STEPPED</code>: Show steps in line.
         *        </p>
         *        </li>
         * @see LineInterpolation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineInterpolation
         */
        Builder lineInterpolation(LineInterpolation lineInterpolation);

        /**
         * <p>
         * Line style for line series.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SOLID</code>: Show as a solid line.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DOTTED</code>: Show as a dotted line.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DASHED</code>: Show as a dashed line.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lineStyle
         *        Line style for line series.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SOLID</code>: Show as a solid line.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DOTTED</code>: Show as a dotted line.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DASHED</code>: Show as a dashed line.
         *        </p>
         *        </li>
         * @see LineChartLineStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineChartLineStyle
         */
        Builder lineStyle(String lineStyle);

        /**
         * <p>
         * Line style for line series.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SOLID</code>: Show as a solid line.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DOTTED</code>: Show as a dotted line.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DASHED</code>: Show as a dashed line.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lineStyle
         *        Line style for line series.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SOLID</code>: Show as a solid line.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DOTTED</code>: Show as a dotted line.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DASHED</code>: Show as a dashed line.
         *        </p>
         *        </li>
         * @see LineChartLineStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineChartLineStyle
         */
        Builder lineStyle(LineChartLineStyle lineStyle);

        /**
         * <p>
         * Width that determines the line thickness.
         * </p>
         * 
         * @param lineWidth
         *        Width that determines the line thickness.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineWidth(String lineWidth);
    }

    static final class BuilderImpl implements Builder {
        private String lineVisibility;

        private String lineInterpolation;

        private String lineStyle;

        private String lineWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(LineChartLineStyleSettings model) {
            lineVisibility(model.lineVisibility);
            lineInterpolation(model.lineInterpolation);
            lineStyle(model.lineStyle);
            lineWidth(model.lineWidth);
        }

        public final String getLineVisibility() {
            return lineVisibility;
        }

        public final void setLineVisibility(String lineVisibility) {
            this.lineVisibility = lineVisibility;
        }

        @Override
        public final Builder lineVisibility(String lineVisibility) {
            this.lineVisibility = lineVisibility;
            return this;
        }

        @Override
        public final Builder lineVisibility(Visibility lineVisibility) {
            this.lineVisibility(lineVisibility == null ? null : lineVisibility.toString());
            return this;
        }

        public final String getLineInterpolation() {
            return lineInterpolation;
        }

        public final void setLineInterpolation(String lineInterpolation) {
            this.lineInterpolation = lineInterpolation;
        }

        @Override
        public final Builder lineInterpolation(String lineInterpolation) {
            this.lineInterpolation = lineInterpolation;
            return this;
        }

        @Override
        public final Builder lineInterpolation(LineInterpolation lineInterpolation) {
            this.lineInterpolation(lineInterpolation == null ? null : lineInterpolation.toString());
            return this;
        }

        public final String getLineStyle() {
            return lineStyle;
        }

        public final void setLineStyle(String lineStyle) {
            this.lineStyle = lineStyle;
        }

        @Override
        public final Builder lineStyle(String lineStyle) {
            this.lineStyle = lineStyle;
            return this;
        }

        @Override
        public final Builder lineStyle(LineChartLineStyle lineStyle) {
            this.lineStyle(lineStyle == null ? null : lineStyle.toString());
            return this;
        }

        public final String getLineWidth() {
            return lineWidth;
        }

        public final void setLineWidth(String lineWidth) {
            this.lineWidth = lineWidth;
        }

        @Override
        public final Builder lineWidth(String lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        @Override
        public LineChartLineStyleSettings build() {
            return new LineChartLineStyleSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
