/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conditional formatting of a KPI visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KPIConditionalFormatting implements SdkPojo, Serializable,
        ToCopyableBuilder<KPIConditionalFormatting.Builder, KPIConditionalFormatting> {
    private static final SdkField<List<KPIConditionalFormattingOption>> CONDITIONAL_FORMATTING_OPTIONS_FIELD = SdkField
            .<List<KPIConditionalFormattingOption>> builder(MarshallingType.LIST)
            .memberName("ConditionalFormattingOptions")
            .getter(getter(KPIConditionalFormatting::conditionalFormattingOptions))
            .setter(setter(Builder::conditionalFormattingOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalFormattingOptions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KPIConditionalFormattingOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(KPIConditionalFormattingOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONDITIONAL_FORMATTING_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<KPIConditionalFormattingOption> conditionalFormattingOptions;

    private KPIConditionalFormatting(BuilderImpl builder) {
        this.conditionalFormattingOptions = builder.conditionalFormattingOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConditionalFormattingOptions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConditionalFormattingOptions() {
        return conditionalFormattingOptions != null && !(conditionalFormattingOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The conditional formatting options of a KPI visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditionalFormattingOptions} method.
     * </p>
     * 
     * @return The conditional formatting options of a KPI visual.
     */
    public final List<KPIConditionalFormattingOption> conditionalFormattingOptions() {
        return conditionalFormattingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasConditionalFormattingOptions() ? conditionalFormattingOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPIConditionalFormatting)) {
            return false;
        }
        KPIConditionalFormatting other = (KPIConditionalFormatting) obj;
        return hasConditionalFormattingOptions() == other.hasConditionalFormattingOptions()
                && Objects.equals(conditionalFormattingOptions(), other.conditionalFormattingOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KPIConditionalFormatting")
                .add("ConditionalFormattingOptions", hasConditionalFormattingOptions() ? conditionalFormattingOptions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConditionalFormattingOptions":
            return Optional.ofNullable(clazz.cast(conditionalFormattingOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConditionalFormattingOptions", CONDITIONAL_FORMATTING_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KPIConditionalFormatting, T> g) {
        return obj -> g.apply((KPIConditionalFormatting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KPIConditionalFormatting> {
        /**
         * <p>
         * The conditional formatting options of a KPI visual.
         * </p>
         * 
         * @param conditionalFormattingOptions
         *        The conditional formatting options of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionalFormattingOptions(Collection<KPIConditionalFormattingOption> conditionalFormattingOptions);

        /**
         * <p>
         * The conditional formatting options of a KPI visual.
         * </p>
         * 
         * @param conditionalFormattingOptions
         *        The conditional formatting options of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionalFormattingOptions(KPIConditionalFormattingOption... conditionalFormattingOptions);

        /**
         * <p>
         * The conditional formatting options of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.KPIConditionalFormattingOption.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.KPIConditionalFormattingOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.KPIConditionalFormattingOption.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #conditionalFormattingOptions(List<KPIConditionalFormattingOption>)}.
         * 
         * @param conditionalFormattingOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.KPIConditionalFormattingOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionalFormattingOptions(java.util.Collection<KPIConditionalFormattingOption>)
         */
        Builder conditionalFormattingOptions(Consumer<KPIConditionalFormattingOption.Builder>... conditionalFormattingOptions);
    }

    static final class BuilderImpl implements Builder {
        private List<KPIConditionalFormattingOption> conditionalFormattingOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KPIConditionalFormatting model) {
            conditionalFormattingOptions(model.conditionalFormattingOptions);
        }

        public final List<KPIConditionalFormattingOption.Builder> getConditionalFormattingOptions() {
            List<KPIConditionalFormattingOption.Builder> result = KPIConditionalFormattingOptionListCopier
                    .copyToBuilder(this.conditionalFormattingOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditionalFormattingOptions(
                Collection<KPIConditionalFormattingOption.BuilderImpl> conditionalFormattingOptions) {
            this.conditionalFormattingOptions = KPIConditionalFormattingOptionListCopier
                    .copyFromBuilder(conditionalFormattingOptions);
        }

        @Override
        public final Builder conditionalFormattingOptions(Collection<KPIConditionalFormattingOption> conditionalFormattingOptions) {
            this.conditionalFormattingOptions = KPIConditionalFormattingOptionListCopier.copy(conditionalFormattingOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionalFormattingOptions(KPIConditionalFormattingOption... conditionalFormattingOptions) {
            conditionalFormattingOptions(Arrays.asList(conditionalFormattingOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionalFormattingOptions(
                Consumer<KPIConditionalFormattingOption.Builder>... conditionalFormattingOptions) {
            conditionalFormattingOptions(Stream.of(conditionalFormattingOptions)
                    .map(c -> KPIConditionalFormattingOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public KPIConditionalFormatting build() {
            return new KPIConditionalFormatting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
