/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>InnerFilter</code> defines the subset of data to be used with the <code>NestedFilter</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InnerFilter implements SdkPojo, Serializable, ToCopyableBuilder<InnerFilter.Builder, InnerFilter> {
    private static final SdkField<CategoryInnerFilter> CATEGORY_INNER_FILTER_FIELD = SdkField
            .<CategoryInnerFilter> builder(MarshallingType.SDK_POJO).memberName("CategoryInnerFilter")
            .getter(getter(InnerFilter::categoryInnerFilter)).setter(setter(Builder::categoryInnerFilter))
            .constructor(CategoryInnerFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryInnerFilter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_INNER_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CategoryInnerFilter categoryInnerFilter;

    private InnerFilter(BuilderImpl builder) {
        this.categoryInnerFilter = builder.categoryInnerFilter;
    }

    /**
     * <p>
     * A <code>CategoryInnerFilter</code> filters text values for the <code>NestedFilter</code>.
     * </p>
     * 
     * @return A <code>CategoryInnerFilter</code> filters text values for the <code>NestedFilter</code>.
     */
    public final CategoryInnerFilter categoryInnerFilter() {
        return categoryInnerFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryInnerFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InnerFilter)) {
            return false;
        }
        InnerFilter other = (InnerFilter) obj;
        return Objects.equals(categoryInnerFilter(), other.categoryInnerFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InnerFilter").add("CategoryInnerFilter", categoryInnerFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategoryInnerFilter":
            return Optional.ofNullable(clazz.cast(categoryInnerFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CategoryInnerFilter", CATEGORY_INNER_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InnerFilter, T> g) {
        return obj -> g.apply((InnerFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InnerFilter> {
        /**
         * <p>
         * A <code>CategoryInnerFilter</code> filters text values for the <code>NestedFilter</code>.
         * </p>
         * 
         * @param categoryInnerFilter
         *        A <code>CategoryInnerFilter</code> filters text values for the <code>NestedFilter</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryInnerFilter(CategoryInnerFilter categoryInnerFilter);

        /**
         * <p>
         * A <code>CategoryInnerFilter</code> filters text values for the <code>NestedFilter</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CategoryInnerFilter.Builder} avoiding the
         * need to create one manually via {@link CategoryInnerFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CategoryInnerFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #categoryInnerFilter(CategoryInnerFilter)}.
         * 
         * @param categoryInnerFilter
         *        a consumer that will call methods on {@link CategoryInnerFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryInnerFilter(CategoryInnerFilter)
         */
        default Builder categoryInnerFilter(Consumer<CategoryInnerFilter.Builder> categoryInnerFilter) {
            return categoryInnerFilter(CategoryInnerFilter.builder().applyMutation(categoryInnerFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CategoryInnerFilter categoryInnerFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(InnerFilter model) {
            categoryInnerFilter(model.categoryInnerFilter);
        }

        public final CategoryInnerFilter.Builder getCategoryInnerFilter() {
            return categoryInnerFilter != null ? categoryInnerFilter.toBuilder() : null;
        }

        public final void setCategoryInnerFilter(CategoryInnerFilter.BuilderImpl categoryInnerFilter) {
            this.categoryInnerFilter = categoryInnerFilter != null ? categoryInnerFilter.build() : null;
        }

        @Override
        public final Builder categoryInnerFilter(CategoryInnerFilter categoryInnerFilter) {
            this.categoryInnerFilter = categoryInnerFilter;
            return this;
        }

        @Override
        public InnerFilter build() {
            return new InnerFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
