/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the gradient stop configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GradientStop implements SdkPojo, Serializable, ToCopyableBuilder<GradientStop.Builder, GradientStop> {
    private static final SdkField<Double> GRADIENT_OFFSET_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("GradientOffset").getter(getter(GradientStop::gradientOffset)).setter(setter(Builder::gradientOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GradientOffset").build()).build();

    private static final SdkField<Double> DATA_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DataValue").getter(getter(GradientStop::dataValue)).setter(setter(Builder::dataValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataValue").build()).build();

    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(GradientStop::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRADIENT_OFFSET_FIELD,
            DATA_VALUE_FIELD, COLOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double gradientOffset;

    private final Double dataValue;

    private final String color;

    private GradientStop(BuilderImpl builder) {
        this.gradientOffset = builder.gradientOffset;
        this.dataValue = builder.dataValue;
        this.color = builder.color;
    }

    /**
     * <p>
     * Determines gradient offset value.
     * </p>
     * 
     * @return Determines gradient offset value.
     */
    public final Double gradientOffset() {
        return gradientOffset;
    }

    /**
     * <p>
     * Determines the data value.
     * </p>
     * 
     * @return Determines the data value.
     */
    public final Double dataValue() {
        return dataValue;
    }

    /**
     * <p>
     * Determines the color.
     * </p>
     * 
     * @return Determines the color.
     */
    public final String color() {
        return color;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gradientOffset());
        hashCode = 31 * hashCode + Objects.hashCode(dataValue());
        hashCode = 31 * hashCode + Objects.hashCode(color());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GradientStop)) {
            return false;
        }
        GradientStop other = (GradientStop) obj;
        return Objects.equals(gradientOffset(), other.gradientOffset()) && Objects.equals(dataValue(), other.dataValue())
                && Objects.equals(color(), other.color());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GradientStop").add("GradientOffset", gradientOffset()).add("DataValue", dataValue())
                .add("Color", color()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GradientOffset":
            return Optional.ofNullable(clazz.cast(gradientOffset()));
        case "DataValue":
            return Optional.ofNullable(clazz.cast(dataValue()));
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GradientOffset", GRADIENT_OFFSET_FIELD);
        map.put("DataValue", DATA_VALUE_FIELD);
        map.put("Color", COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GradientStop, T> g) {
        return obj -> g.apply((GradientStop) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GradientStop> {
        /**
         * <p>
         * Determines gradient offset value.
         * </p>
         * 
         * @param gradientOffset
         *        Determines gradient offset value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gradientOffset(Double gradientOffset);

        /**
         * <p>
         * Determines the data value.
         * </p>
         * 
         * @param dataValue
         *        Determines the data value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataValue(Double dataValue);

        /**
         * <p>
         * Determines the color.
         * </p>
         * 
         * @param color
         *        Determines the color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);
    }

    static final class BuilderImpl implements Builder {
        private Double gradientOffset;

        private Double dataValue;

        private String color;

        private BuilderImpl() {
        }

        private BuilderImpl(GradientStop model) {
            gradientOffset(model.gradientOffset);
            dataValue(model.dataValue);
            color(model.color);
        }

        public final Double getGradientOffset() {
            return gradientOffset;
        }

        public final void setGradientOffset(Double gradientOffset) {
            this.gradientOffset = gradientOffset;
        }

        @Override
        public final Builder gradientOffset(Double gradientOffset) {
            this.gradientOffset = gradientOffset;
            return this;
        }

        public final Double getDataValue() {
            return dataValue;
        }

        public final void setDataValue(Double dataValue) {
            this.dataValue = dataValue;
        }

        @Override
        public final Builder dataValue(Double dataValue) {
            this.dataValue = dataValue;
            return this;
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        @Override
        public GradientStop build() {
            return new GradientStop(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
