/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties for the visualization of null data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialNullDataSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialNullDataSettings.Builder, GeospatialNullDataSettings> {
    private static final SdkField<GeospatialNullSymbolStyle> SYMBOL_STYLE_FIELD = SdkField
            .<GeospatialNullSymbolStyle> builder(MarshallingType.SDK_POJO).memberName("SymbolStyle")
            .getter(getter(GeospatialNullDataSettings::symbolStyle)).setter(setter(Builder::symbolStyle))
            .constructor(GeospatialNullSymbolStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SymbolStyle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYMBOL_STYLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialNullSymbolStyle symbolStyle;

    private GeospatialNullDataSettings(BuilderImpl builder) {
        this.symbolStyle = builder.symbolStyle;
    }

    /**
     * <p>
     * The symbol style for null data.
     * </p>
     * 
     * @return The symbol style for null data.
     */
    public final GeospatialNullSymbolStyle symbolStyle() {
        return symbolStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(symbolStyle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialNullDataSettings)) {
            return false;
        }
        GeospatialNullDataSettings other = (GeospatialNullDataSettings) obj;
        return Objects.equals(symbolStyle(), other.symbolStyle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialNullDataSettings").add("SymbolStyle", symbolStyle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SymbolStyle":
            return Optional.ofNullable(clazz.cast(symbolStyle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SymbolStyle", SYMBOL_STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialNullDataSettings, T> g) {
        return obj -> g.apply((GeospatialNullDataSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialNullDataSettings> {
        /**
         * <p>
         * The symbol style for null data.
         * </p>
         * 
         * @param symbolStyle
         *        The symbol style for null data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder symbolStyle(GeospatialNullSymbolStyle symbolStyle);

        /**
         * <p>
         * The symbol style for null data.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialNullSymbolStyle.Builder}
         * avoiding the need to create one manually via {@link GeospatialNullSymbolStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialNullSymbolStyle.Builder#build()} is called immediately
         * and its result is passed to {@link #symbolStyle(GeospatialNullSymbolStyle)}.
         * 
         * @param symbolStyle
         *        a consumer that will call methods on {@link GeospatialNullSymbolStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #symbolStyle(GeospatialNullSymbolStyle)
         */
        default Builder symbolStyle(Consumer<GeospatialNullSymbolStyle.Builder> symbolStyle) {
            return symbolStyle(GeospatialNullSymbolStyle.builder().applyMutation(symbolStyle).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeospatialNullSymbolStyle symbolStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialNullDataSettings model) {
            symbolStyle(model.symbolStyle);
        }

        public final GeospatialNullSymbolStyle.Builder getSymbolStyle() {
            return symbolStyle != null ? symbolStyle.toBuilder() : null;
        }

        public final void setSymbolStyle(GeospatialNullSymbolStyle.BuilderImpl symbolStyle) {
            this.symbolStyle = symbolStyle != null ? symbolStyle.build() : null;
        }

        @Override
        public final Builder symbolStyle(GeospatialNullSymbolStyle symbolStyle) {
            this.symbolStyle = symbolStyle;
            return this;
        }

        @Override
        public GeospatialNullDataSettings build() {
            return new GeospatialNullDataSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
